/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.rest.mappingcontext;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.content.commons.annotations.ContentId;
import org.springframework.content.commons.mappingcontext.ClassVisitor;
import org.springframework.content.commons.mappingcontext.ClassWalker;
import org.springframework.content.commons.utils.ContentPropertyUtils;
import org.springframework.content.rest.RestResource;
import org.springframework.util.StringUtils;

public class RestResourceMappingBuilder
implements ClassVisitor {
    private final Function<RestResource, String> segmentProvider;
    private Stack<String> segments = new Stack();
    private Stack<String> uriSegments = new Stack();
    private Map<String, String> mappings = new HashMap<String, String>();
    private Map<String, Boolean> visited = new HashMap<String, Boolean>();
    private Map<String, Boolean> looseModes = new HashMap<String, Boolean>();

    public RestResourceMappingBuilder(Function<RestResource, String> segmentProvider) {
        this.segmentProvider = segmentProvider;
    }

    public boolean visitClass(String path, Class<?> klazz) {
        this.visited.put(klazz + ":" + this.path(this.segments), false);
        int numContentIds = 0;
        for (Field field : klazz.getDeclaredFields()) {
            if (!field.isAnnotationPresent(ContentId.class)) continue;
            ++numContentIds;
        }
        this.looseModes.put(klazz + ":" + this.path(this.segments), numContentIds == 1);
        return true;
    }

    public boolean visitFieldBefore(String path, Class<?> klazz, Field f) {
        if (this.isObject(f) || f.isAnnotationPresent(ContentId.class) && this.looseModes.get(klazz + ":" + this.path(this.segments)) == Boolean.FALSE || f.isAnnotationPresent(ContentId.class) && this.looseModes.get(klazz + ":" + this.path(this.segments)) == Boolean.TRUE && this.segments.size() == 0) {
            RestResource restResource = f.getAnnotation(RestResource.class);
            if (restResource != null) {
                String segment = this.segmentProvider.apply(restResource);
                if (StringUtils.hasLength((String)segment)) {
                    this.segments.push(segment);
                } else if (f.isAnnotationPresent(ContentId.class)) {
                    this.segments.push(ClassWalker.propertyName((String)f.getName()));
                } else {
                    this.segments.push(f.getName());
                }
            } else if (f.isAnnotationPresent(ContentId.class)) {
                this.segments.push(ClassWalker.propertyName((String)f.getName()));
            } else {
                this.segments.push(f.getName());
            }
            if (f.isAnnotationPresent(ContentId.class)) {
                this.uriSegments.push(ClassWalker.propertyName((String)f.getName()));
            } else {
                this.uriSegments.push(f.getName());
            }
            this.visited.put(klazz + ":" + this.path(this.segments), true);
        }
        return true;
    }

    public boolean visitField(String path, Class<?> klazz, Field f) {
        if (f.isAnnotationPresent(ContentId.class)) {
            this.mappings.put(this.path(this.uriSegments), this.path(this.segments));
        }
        return true;
    }

    public boolean visitFieldAfter(String path, Class<?> klazz, Field f) {
        if (this.visited.get(klazz + ":" + this.path(this.segments)).booleanValue()) {
            this.segments.pop();
            this.uriSegments.pop();
        }
        return true;
    }

    public boolean visitClassEnd(String path, Class<?> klazz) {
        return true;
    }

    public Map<String, String> getMappings() {
        return this.mappings;
    }

    public Map<String, String> getInverseMappings() {
        return this.mappings.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
    }

    private boolean isObject(Field field) {
        return !field.getType().isPrimitive() && !field.getType().equals(String.class) && !field.getType().equals(UUID.class) && !field.getType().isEnum() && !ContentPropertyUtils.isWrapperType(field.getType()) && !ContentPropertyUtils.isRelationshipField((Field)field);
    }

    private String path(Stack<String> segments) {
        Object fqPath = "";
        for (int i = 0; i < segments.size(); ++i) {
            if (i > 0) {
                fqPath = (String)fqPath + "/";
            }
            fqPath = (String)fqPath + (String)segments.get(i);
        }
        return fqPath;
    }
}

