/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.rest.mappings;

import internal.org.springframework.content.rest.annotations.StoreAwareController;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Collections;
import java.util.Set;
import org.springframework.content.rest.config.RestConfiguration;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.web.servlet.mvc.condition.PatternsRequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public class StoreAwareHandlerMapping
extends RequestMappingHandlerMapping {
    private RestConfiguration configuration;
    private String prefix;

    public StoreAwareHandlerMapping(RestConfiguration configuration) {
        Assert.notNull((Object)configuration, (String)"RestConfiguration must not be null!");
        this.configuration = configuration;
    }

    public RestConfiguration getConfiguration() {
        return this.configuration;
    }

    protected RequestMappingInfo getMappingForMethod(Method method, Class<?> handlerType) {
        RequestMappingInfo info = super.getMappingForMethod(method, handlerType);
        if (info == null) {
            return null;
        }
        RequestMappingInfo.Builder builder = info.mutate();
        Set patterns = info.getPatternsCondition() != null ? info.getPatternsCondition().getPatterns() : Collections.emptySet();
        String[] augmentedPatterns = new String[patterns.size()];
        int count = 0;
        for (String pattern : patterns) {
            augmentedPatterns[count++] = this.prefix.concat(pattern);
        }
        builder.paths(augmentedPatterns);
        return builder.build().combine(info);
    }

    protected boolean isHandler(Class<?> beanType) {
        Class type = ClassUtils.getUserClass(beanType);
        return type.isAnnotationPresent(StoreAwareController.class);
    }

    public void afterPropertiesSet() {
        URI baseUri = this.configuration.getBaseUri();
        if (baseUri.isAbsolute()) {
            throw new UnsupportedOperationException(String.format("absolute base URIs not supported %s", baseUri));
        }
        this.prefix = baseUri.toString();
        super.afterPropertiesSet();
    }

    protected PatternsRequestCondition customize(PatternsRequestCondition condition, String prefix) {
        if (!condition.isEmpty()) {
            return condition;
        }
        Set patterns = condition.getPatterns();
        String[] augmentedPatterns = new String[patterns.size()];
        int count = 0;
        for (String pattern : patterns) {
            augmentedPatterns[count++] = prefix.concat(pattern);
        }
        return new PatternsRequestCondition(augmentedPatterns, false, this.getPathMatcher());
    }
}

