/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.data.rest.extensions.contentsearch;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.content.rest.FulltextEntityLookupQuery;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.rest.webmvc.RootResourceInformation;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class QueryMethodsEntityLookupStrategy {
    private static final String CONTENT_IDS = "contentIds";

    public void lookup(RootResourceInformation rri, RepositoryInformation ri, List<Object> contentIds, List<Object> results) {
        HashMap<Object, Object> contentIdToEntities = new HashMap<Object, Object>();
        for (Object contentId : contentIds) {
            contentIdToEntities.put(contentId, null);
        }
        ri.getQueryMethods().stream().filter(m -> m.getAnnotation(FulltextEntityLookupQuery.class) != null).forEach(m -> {
            int size = contentIds.size();
            for (int i = 0; i < size; i += 250) {
                int lowerbound = i;
                int upperbound = lowerbound + 250 <= size ? lowerbound + 250 : size;
                List subset = contentIds.subList(lowerbound, upperbound);
                Map map = Collections.singletonMap(CONTENT_IDS, subset);
                LinkedMultiValueMap args = new LinkedMultiValueMap(map);
                Optional partialResults = rri.getInvoker().invokeQueryMethod(m, (MultiValueMap)args, Pageable.unpaged(), Sort.unsorted());
                if (!partialResults.isPresent()) continue;
                results.addAll((List)partialResults.get());
            }
        });
    }
}

