/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.rest.contentservice;

import internal.org.springframework.content.rest.contentservice.ContentService;
import internal.org.springframework.content.rest.contentservice.ContentStoreContentService;
import internal.org.springframework.content.rest.controllers.MethodNotAllowedException;
import internal.org.springframework.content.rest.io.RenderableResource;
import internal.org.springframework.content.rest.io.RenderedResource;
import internal.org.springframework.content.rest.mappings.StoreByteRangeHttpRequestHandler;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.content.commons.io.DeletableResource;
import org.springframework.content.commons.io.RangeableResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.WritableResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.util.Assert;
import org.springframework.util.MimeType;
import org.springframework.web.server.ResponseStatusException;

public class StoreContentService
implements ContentService {
    private static final Logger logger = LoggerFactory.getLogger(StoreContentService.class);
    private final StoreByteRangeHttpRequestHandler byteRangeRestRequestHandler;

    public StoreContentService(StoreByteRangeHttpRequestHandler byteRangeRestRequestHandler) {
        this.byteRangeRestRequestHandler = byteRangeRestRequestHandler;
    }

    @Override
    public void getContent(HttpServletRequest request, HttpServletResponse response, HttpHeaders headers, Resource resource, MediaType resourceType) throws ResponseStatusException {
        block9: {
            try {
                MediaType producedResourceType = null;
                List acceptedMimeTypes = headers.getAccept();
                if (acceptedMimeTypes.size() > 0) {
                    MediaType.sortBySpecificityAndQuality((List)acceptedMimeTypes);
                    for (MediaType acceptedMimeType : acceptedMimeTypes) {
                        if (resource instanceof RenderableResource && ((RenderableResource)resource).isRenderableAs((MimeType)acceptedMimeType)) {
                            resource = new RenderedResource(((RenderableResource)resource).renderAs((MimeType)acceptedMimeType), (Resource)resource);
                            producedResourceType = acceptedMimeType;
                            break;
                        }
                        if (!acceptedMimeType.includes(resourceType)) continue;
                        producedResourceType = resourceType;
                        break;
                    }
                    if (producedResourceType == null) {
                        response.setStatus(HttpStatus.NOT_FOUND.value());
                        return;
                    }
                }
                if (resource instanceof RangeableResource) {
                    this.configureResourceForByteRangeRequest((RangeableResource)resource, headers);
                }
                request.setAttribute("SPRING_CONTENT_RESOURCE", resource);
                request.setAttribute("SPRING_CONTENT_CONTENTTYPE", producedResourceType);
            }
            catch (Exception e) {
                logger.error("Unable to retrieve content", (Throwable)e);
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, String.format("Failed to handle request for %s", resource.getDescription()), (Throwable)e);
            }
            try {
                this.byteRangeRestRequestHandler.handleRequest(request, response);
            }
            catch (Exception e) {
                if (ContentStoreContentService.isClientAbortException(e)) break block9;
                logger.error("Unable to handle request", (Throwable)e);
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, String.format("Failed to handle request for %s", resource.getDescription()), (Throwable)e);
            }
        }
    }

    @Override
    public void setContent(HttpServletRequest request, HttpServletResponse response, HttpHeaders headers, Resource source, MediaType sourceMimeType, Resource target) throws IOException, MethodNotAllowedException {
        InputStream in = source.getInputStream();
        OutputStream out = ((WritableResource)target).getOutputStream();
        IOUtils.copy((InputStream)in, (OutputStream)out);
        IOUtils.closeQuietly((OutputStream)out);
        IOUtils.closeQuietly((InputStream)in);
    }

    @Override
    public void unsetContent(Resource resource) {
        Assert.notNull((Object)resource);
        if (resource instanceof DeletableResource) {
            try {
                ((DeletableResource)resource).delete();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void configureResourceForByteRangeRequest(RangeableResource resource, HttpHeaders headers) {
        if (headers.containsKey((Object)"Range")) {
            resource.setRange(headers.getFirst("Range"));
        }
    }
}

