/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.rest.mappingcontext;

import org.apache.commons.lang.StringUtils;
import org.springframework.util.Assert;

public class ContentPropertyRequest {
    private final String store;
    private final String id;
    private final String contentPropertyPath;

    private ContentPropertyRequest(String store, String id, String contentPropertyPath) {
        Assert.hasLength((String)store, (String)"invalid store");
        this.store = store;
        Assert.hasLength((String)store, (String)"invalid id");
        this.id = id;
        Assert.notNull((Object)store, (String)"invalid content property path");
        this.contentPropertyPath = contentPropertyPath;
    }

    public String getRequestURI() {
        return String.format("/%s/%s/%s", this.store, this.id, this.contentPropertyPath);
    }

    public static ContentPropertyRequest from(String storeLookupPath) {
        Assert.notNull((Object)storeLookupPath);
        Object[] path = storeLookupPath.split("/");
        if (path.length < 3) {
            throw new IllegalStateException("invalid content property request");
        }
        return new ContentPropertyRequest(path[1], path[2], StringUtils.join((Object[])path, (String)"/", (int)3, (int)path.length));
    }

    public static ContentPropertyRequest from(String store, String id, String contentPropertyPath) {
        return new ContentPropertyRequest(store, id, contentPropertyPath);
    }

    public String getStore() {
        return this.store;
    }

    public String getId() {
        return this.id;
    }

    public String getContentPropertyPath() {
        return this.contentPropertyPath;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContentPropertyRequest)) {
            return false;
        }
        ContentPropertyRequest other = (ContentPropertyRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$store = this.getStore();
        String other$store = other.getStore();
        if (this$store == null ? other$store != null : !this$store.equals(other$store)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$contentPropertyPath = this.getContentPropertyPath();
        String other$contentPropertyPath = other.getContentPropertyPath();
        return !(this$contentPropertyPath == null ? other$contentPropertyPath != null : !this$contentPropertyPath.equals(other$contentPropertyPath));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ContentPropertyRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $store = this.getStore();
        result = result * 59 + ($store == null ? 43 : $store.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $contentPropertyPath = this.getContentPropertyPath();
        result = result * 59 + ($contentPropertyPath == null ? 43 : $contentPropertyPath.hashCode());
        return result;
    }

    public String toString() {
        return "ContentPropertyRequest(store=" + this.getStore() + ", id=" + this.getId() + ", contentPropertyPath=" + this.getContentPropertyPath() + ")";
    }
}

