/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.rest.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.rest.webmvc.PersistentEntityResourceAssembler;
import org.springframework.data.web.PagedResourcesAssembler;
import org.springframework.hateoas.CollectionModel;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.server.RepresentationModelAssembler;
import org.springframework.hateoas.server.core.EmbeddedWrappers;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;

public final class ControllerUtils {
    private static final EmbeddedWrappers WRAPPERS = new EmbeddedWrappers(false);

    private ControllerUtils() {
    }

    protected static CollectionModel<?> entitiesToResources(Page<Object> page, PagedResourcesAssembler<Object> prAssembler, PersistentEntityResourceAssembler assembler, Class<?> domainType) {
        if (page.getContent().isEmpty()) {
            return prAssembler.toEmptyModel(page, domainType);
        }
        if (assembler != null) {
            return prAssembler.toModel(page, (RepresentationModelAssembler)assembler);
        }
        return prAssembler.toModel(page);
    }

    protected static CollectionModel<?> entitiesToResources(Iterable<Object> entities, PersistentEntityResourceAssembler assembler, Class<?> domainType) {
        if (!entities.iterator().hasNext()) {
            List<Object> content = Arrays.asList(WRAPPERS.emptyCollectionOf(domainType));
            return CollectionModel.of(content, (Link[])new Link[]{ControllerUtils.getDefaultSelfLink()});
        }
        ArrayList<Object> resources = new ArrayList<Object>();
        for (Object obj : entities) {
            if (assembler != null) {
                resources.add(obj == null ? null : assembler.toModel(obj));
                continue;
            }
            EntityModel m = EntityModel.of((Object)obj);
            resources.add(m);
        }
        return CollectionModel.of(resources, (Link[])new Link[]{ControllerUtils.getDefaultSelfLink()});
    }

    protected static Link getDefaultSelfLink() {
        return Link.of((String)ServletUriComponentsBuilder.fromCurrentRequest().build().toUriString());
    }

    public static CollectionModel<?> toCollectionModel(Iterable<?> source, PagedResourcesAssembler<Object> prAssembler, PersistentEntityResourceAssembler assembler, Class<?> domainType) {
        if (source instanceof Page) {
            Page page = (Page)source;
            return ControllerUtils.entitiesToResources((Page<Object>)page, prAssembler, assembler, domainType);
        }
        if (source instanceof Iterable) {
            return ControllerUtils.entitiesToResources(source, assembler, domainType);
        }
        return CollectionModel.empty();
    }
}

