/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.rest.utils;

import internal.org.springframework.content.rest.annotations.ContentStoreRestResource;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import org.atteo.evo.inflector.English;
import org.springframework.content.commons.storeservice.StoreFilter;
import org.springframework.content.commons.storeservice.StoreInfo;
import org.springframework.content.rest.StoreRestResource;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.MimeType;
import org.springframework.util.StringUtils;

public final class StoreUtils {
    private StoreUtils() {
    }

    public static StoreFilter withStorePath(final String storePath) {
        return new StoreFilter(){

            public String name() {
                return storePath;
            }

            public boolean matches(StoreInfo info) {
                return storePath.equals(StoreUtils.storePath(info));
            }
        };
    }

    public static String storePath(StoreInfo info) {
        StoreRestResource newAnnotation;
        Class clazz = info.getInterface();
        String path = null;
        ContentStoreRestResource oldAnnotation = (ContentStoreRestResource)AnnotationUtils.findAnnotation((Class)clazz, ContentStoreRestResource.class);
        path = oldAnnotation != null ? (oldAnnotation == null ? null : oldAnnotation.path().trim()) : ((newAnnotation = (StoreRestResource)AnnotationUtils.findAnnotation((Class)clazz, StoreRestResource.class)) == null ? null : newAnnotation.path().trim());
        path = StringUtils.hasText((String)path) ? path : English.plural((String)StringUtils.uncapitalize((String)StoreUtils.getSimpleName(info)));
        return path;
    }

    public static String getSimpleName(StoreInfo info) {
        Class clazz = info.getDomainObjectClass();
        return clazz != null ? clazz.getSimpleName() : StoreUtils.stripStoreName(info.getInterface());
    }

    public static String stripStoreName(Class<?> iface) {
        return iface.getSimpleName().replaceAll("Store", "");
    }

    public static String storeLookupPath(String requestPath, URI baseUri) {
        Assert.notNull((Object)requestPath, (String)"requestPath must not be null");
        Assert.notNull((Object)baseUri, (String)"baseUri must not be null");
        requestPath = requestPath.replaceAll("//", "/");
        requestPath = StringUtils.trimTrailingCharacter((String)requestPath, (char)'/');
        if (baseUri.isAbsolute()) {
            throw new UnsupportedOperationException("Absolute BaseUri is not supported");
        }
        String uri = baseUri.toString();
        if (!StringUtils.hasText((String)uri)) {
            return requestPath;
        }
        uri = uri.startsWith("/") ? uri : "/".concat(uri);
        return requestPath.startsWith(uri) ? requestPath.substring(uri.length(), requestPath.length()) : null;
    }

    public static class NonExistentResource
    implements Resource {
        public boolean exists() {
            return false;
        }

        public URL getURL() throws IOException {
            throw new UnsupportedOperationException();
        }

        public URI getURI() throws IOException {
            throw new UnsupportedOperationException();
        }

        public File getFile() throws IOException {
            throw new UnsupportedOperationException();
        }

        public long contentLength() throws IOException {
            throw new UnsupportedOperationException();
        }

        public long lastModified() throws IOException {
            throw new UnsupportedOperationException();
        }

        public Resource createRelative(String s) throws IOException {
            throw new UnsupportedOperationException();
        }

        public String getFilename() {
            throw new UnsupportedOperationException();
        }

        public String getDescription() {
            throw new UnsupportedOperationException();
        }

        public InputStream getInputStream() throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    public static class ResourcePlan {
        private Resource resource;
        private MimeType mimeType;

        public ResourcePlan(Resource r, MimeType mimeType) {
            this.resource = r;
            this.mimeType = mimeType;
        }

        public Resource getResource() {
            return this.resource;
        }

        public MimeType getMimeType() {
            return this.mimeType;
        }
    }
}

