/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.extensions.contentsearch;

import internal.org.springframework.content.rest.controllers.BadRequestException;
import internal.org.springframework.content.rest.mappings.ContentHandlerMapping;
import internal.org.springframework.content.rest.utils.ControllerUtils;
import internal.org.springframework.content.rest.utils.RepositoryUtils;
import internal.org.springframework.data.rest.extensions.contentsearch.DefaultEntityLookupStrategy;
import internal.org.springframework.data.rest.extensions.contentsearch.QueryMethodsEntityLookupStrategy;
import jakarta.persistence.Id;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.content.commons.annotations.ContentId;
import org.springframework.content.commons.fragments.ParameterTypeAware;
import org.springframework.content.commons.repository.ContentStore;
import org.springframework.content.commons.search.Searchable;
import org.springframework.content.commons.storeservice.StoreFilter;
import org.springframework.content.commons.storeservice.StoreInfo;
import org.springframework.content.commons.storeservice.Stores;
import org.springframework.content.commons.utils.BeanUtils;
import org.springframework.content.commons.utils.ContentPropertyUtils;
import org.springframework.content.commons.utils.DomainObjectUtils;
import org.springframework.content.commons.utils.ReflectionService;
import org.springframework.content.commons.utils.ReflectionServiceImpl;
import org.springframework.content.rest.FulltextEntityLookupQuery;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.support.Repositories;
import org.springframework.data.rest.webmvc.PersistentEntityResourceAssembler;
import org.springframework.data.rest.webmvc.RepositoryRestController;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.data.rest.webmvc.RootResourceInformation;
import org.springframework.data.rest.webmvc.support.DefaultedPageable;
import org.springframework.data.web.PagedResourcesAssembler;
import org.springframework.hateoas.CollectionModel;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@RepositoryRestController
public class ContentSearchRestController {
    private static final String ENTITY_CONTENTSEARCH_MAPPING = "/{repository}/searchContent";
    private static final String ENTITY_SEARCHMETHOD_MAPPING = "/{repository}/searchContent/findKeyword";
    private static Map<String, Method> searchMethods = new HashMap<String, Method>();
    private Repositories repositories;
    private Stores stores;
    private PagedResourcesAssembler<Object> pagedResourcesAssembler;
    private DefaultEntityLookupStrategy defaultLookupStrategy;
    private QueryMethodsEntityLookupStrategy qmLookupStrategy;
    private ReflectionService reflectionService;

    private static void put(Map<String, Method> methods, String key, Method findMethod) {
        methods.put(String.format("%s:%s", key, Arrays.toString(findMethod.getParameterTypes())), findMethod);
    }

    @Autowired
    public ContentSearchRestController(Repositories repositories, Stores stores, PagedResourcesAssembler<Object> assembler) {
        this.repositories = repositories;
        this.stores = stores;
        this.pagedResourcesAssembler = assembler;
        this.reflectionService = new ReflectionServiceImpl();
        this.defaultLookupStrategy = new DefaultEntityLookupStrategy();
        this.qmLookupStrategy = new QueryMethodsEntityLookupStrategy();
    }

    public void setReflectionService(ReflectionService reflectionService) {
        this.reflectionService = reflectionService;
    }

    public void setDefaultEntityLookupStrategy(DefaultEntityLookupStrategy lookupStrategy) {
        this.defaultLookupStrategy = lookupStrategy;
    }

    public void setQueryMethodsEntityLookupStrategy(QueryMethodsEntityLookupStrategy lookupStrategy) {
        this.qmLookupStrategy = lookupStrategy;
    }

    @ContentHandlerMapping.StoreType(value="contentstore")
    @ResponseBody
    @RequestMapping(value={"/{repository}/searchContent"}, method={RequestMethod.GET})
    public CollectionModel<?> searchContent(RootResourceInformation repoInfo, DefaultedPageable pageable, Sort sort, PersistentEntityResourceAssembler assembler, @PathVariable String repository, @RequestParam(name="queryString") String queryString) {
        return this.searchContentInternal(repoInfo, repository, pageable, sort, assembler, "search", new String[]{queryString});
    }

    @ContentHandlerMapping.StoreType(value="contentstore")
    @ResponseBody
    @RequestMapping(value={"/{repository}/searchContent/findKeyword"}, method={RequestMethod.GET})
    public CollectionModel<?> searchContent(RootResourceInformation repoInfo, DefaultedPageable pageable, Sort sort, PersistentEntityResourceAssembler assembler, @PathVariable String repository, @RequestParam(name="keyword") List<String> keywords) {
        return this.searchContentInternal(repoInfo, repository, pageable, sort, assembler, "findKeyword", keywords.toArray(new String[0]));
    }

    private CollectionModel<?> searchContentInternal(final RootResourceInformation repoInfo, String repository, DefaultedPageable pageable, Sort sort, PersistentEntityResourceAssembler assembler, String searchMethod, String[] keywords) {
        Object[] objectArray;
        Object[] objectArray2;
        StoreInfo[] infos = this.stores.getStores(ContentStore.class, new StoreFilter(){

            public String name() {
                return "test";
            }

            public boolean matches(StoreInfo info) {
                return repoInfo.getDomainType().equals(info.getDomainObjectClass());
            }
        });
        if (infos.length == 0) {
            throw new ResourceNotFoundException("Entity has no content associations");
        }
        if (infos.length > 1) {
            throw new IllegalStateException(String.format("Too many content assocation for Entity %s", repoInfo.getDomainType().getCanonicalName()));
        }
        StoreInfo info = infos[0];
        ContentStore store = (ContentStore)info.getImplementation(ContentStore.class);
        if (!(store instanceof Searchable)) {
            throw new ResourceNotFoundException("Entity content is not searchable");
        }
        if (pageable.unpagedIfDefault().isUnpaged()) {
            Object[] objectArray3 = new Class[1];
            objectArray2 = objectArray3;
            objectArray3[0] = String.class;
        } else {
            Class[] classArray = new Class[2];
            classArray[0] = String.class;
            objectArray2 = classArray;
            classArray[1] = Pageable.class;
        }
        Object[] searchMethodArgTypes = objectArray2;
        Method method = searchMethods.get(String.format("%s:%s", searchMethod, Arrays.toString(searchMethodArgTypes)));
        if (method == null) {
            throw new BadRequestException(String.format("Invalid search: %s", searchMethod));
        }
        if (keywords == null || keywords.length == 0) {
            throw new BadRequestException();
        }
        Class<Object> returnType = this.returnType(info);
        if (ContentPropertyUtils.isPrimitiveContentPropertyClass(returnType)) {
            Method parameterTypeAwareMethod = ReflectionUtils.findMethod(ParameterTypeAware.class, (String)"setGenericArguments", (Class[])new Class[]{Class[].class});
            if (parameterTypeAwareMethod != null) {
                this.reflectionService.invokeMethod(parameterTypeAwareMethod, (Object)store, new Object[]{new Class[]{InternalResult.class}});
            }
            returnType = InternalResult.class;
        }
        if (pageable.unpagedIfDefault().isUnpaged()) {
            String[] stringArray = new String[1];
            objectArray = stringArray;
            stringArray[0] = keywords[0];
        } else {
            Object[] objectArray4 = new Object[2];
            objectArray4[0] = keywords[0];
            objectArray = objectArray4;
            objectArray4[1] = pageable.getPageable();
        }
        Object[] argValues = objectArray;
        Iterable intermediateResults = (Iterable)this.reflectionService.invokeMethod(method, (Object)store, argValues);
        if (intermediateResults == null || !intermediateResults.iterator().hasNext()) {
            return CollectionModel.empty();
        }
        ArrayList<Object> results = new ArrayList<Object>();
        RepositoryInformation ri = RepositoryUtils.findRepositoryInformation(this.repositories, repository);
        Class domainClass = ri.getDomainType();
        if (returnType.equals(InternalResult.class)) {
            boolean idFieldEqualsContentIdField = this.isIdFieldOverloaded(repoInfo.getDomainType());
            ArrayList<Object> entityIds = new ArrayList<Object>();
            ArrayList<Object> contentIds = new ArrayList<Object>();
            for (Object tempResult : intermediateResults) {
                InternalResult internalResult = (InternalResult)tempResult;
                if (internalResult.getId() != null) {
                    entityIds.add(internalResult.getId());
                    continue;
                }
                if (idFieldEqualsContentIdField) {
                    entityIds.add(internalResult.getContentId());
                    continue;
                }
                if (internalResult.getContentId() == null) continue;
                contentIds.add(internalResult.getContentId());
            }
            if (entityIds.size() > 0) {
                this.repositories.getRepositoryFor(domainClass).ifPresent(r -> ContentSearchRestController.fetchEntitiesInBatches((CrudRepository)r, entityIds, results));
            }
            if (contentIds.size() > 0 && ri != null) {
                if (ri.getQueryMethods().filter(m -> m.getAnnotation(FulltextEntityLookupQuery.class) != null).isEmpty()) {
                    this.defaultLookupStrategy.lookup(repoInfo, ri, contentIds, results);
                } else {
                    this.qmLookupStrategy.lookup(repoInfo, ri, contentIds, results);
                }
            }
            Iterable<?> wrappedResults = this.convertToFinalResultType(results, pageable, intermediateResults);
            return ControllerUtils.toCollectionModel(wrappedResults, this.pagedResourcesAssembler, assembler, domainClass);
        }
        intermediateResults.forEach(results::add);
        Iterable<?> wrappedResults = this.convertToFinalResultType(results, pageable, intermediateResults);
        return ControllerUtils.toCollectionModel(wrappedResults, this.pagedResourcesAssembler, null, results.get(0).getClass());
    }

    private Iterable<?> convertToFinalResultType(List<Object> results, DefaultedPageable pageable, Iterable intermediateResults) {
        if (pageable.unpagedIfDefault().isUnpaged()) {
            return results;
        }
        if (intermediateResults instanceof Page) {
            return new PageImpl(results, pageable.getPageable(), (long)((Page)intermediateResults).getTotalPages());
        }
        return new PageImpl(results);
    }

    public static void fetchEntitiesInBatches(CrudRepository<?, ?> r, List entityIds, List results) {
        int size = entityIds.size();
        Method findAllByIdMethod = ReflectionUtils.findMethod(CrudRepository.class, (String)"findAllById", (Class[])new Class[]{Iterable.class});
        for (int i = 0; i < size; i += 250) {
            int lowerbound = i;
            int upperbound = lowerbound + 250 <= entityIds.size() ? lowerbound + 250 : size;
            List subset = entityIds.subList(lowerbound, upperbound);
            Iterable entities = (Iterable)ReflectionUtils.invokeMethod((Method)findAllByIdMethod, r, (Object[])new Object[]{subset});
            for (Object entity : entities) {
                results.add(entity);
            }
        }
    }

    private Class<?> returnType(StoreInfo info) {
        Class storeInterfaceClass = info.getInterface();
        Class searchReturnType = String.class;
        for (Type t : storeInterfaceClass.getGenericInterfaces()) {
            Type[] fragmentGenericTypes;
            if (!t.getTypeName().startsWith("org.springframework.content.commons.search") || !(t instanceof ParameterizedType) || (fragmentGenericTypes = ((ParameterizedType)t).getActualTypeArguments()) == null) continue;
            searchReturnType = (Class)fragmentGenericTypes[0];
        }
        return searchReturnType;
    }

    private boolean isIdFieldOverloaded(Class<?> domainClass) {
        Field contentIdField;
        Field idField = DomainObjectUtils.getIdField(domainClass);
        return idField.equals(contentIdField = BeanUtils.findFieldWithAnnotation(domainClass, ContentId.class));
    }

    static {
        ContentSearchRestController.put(searchMethods, "search", ReflectionUtils.findMethod(Searchable.class, (String)"search", (Class[])new Class[]{String.class}));
        ContentSearchRestController.put(searchMethods, "search", ReflectionUtils.findMethod(Searchable.class, (String)"search", (Class[])new Class[]{String.class, Pageable.class}));
        ContentSearchRestController.put(searchMethods, "findKeyword", ReflectionUtils.findMethod(Searchable.class, (String)"findKeyword", (Class[])new Class[]{String.class}));
    }

    public static class InternalResult {
        @Id
        private Object id;
        @ContentId
        private Object contentId;

        public Object getId() {
            return this.id;
        }

        public Object getContentId() {
            return this.contentId;
        }

        public void setId(Object id) {
            this.id = id;
        }

        public void setContentId(Object contentId) {
            this.contentId = contentId;
        }

        public InternalResult() {
        }

        public InternalResult(Object id, Object contentId) {
            this.id = id;
            this.contentId = contentId;
        }
    }
}

