/*
 * Decompiled with CFR 0.152.
 */
package org.petitparser.context;

import java.util.List;
import java.util.Objects;
import org.petitparser.parser.Parser;
import org.petitparser.parser.primitive.CharacterParser;

public class Token {
    private final String buffer;
    private final int start;
    private final int stop;
    private final Object value;
    public static final Parser NEWLINE_PARSER = CharacterParser.of('\n').or(CharacterParser.of('\r').seq(CharacterParser.of('\n').optional()));

    public Token(String buffer, int start, int stop, Object value) {
        this.buffer = buffer;
        this.start = start;
        this.stop = stop;
        this.value = value;
    }

    public String getBuffer() {
        return this.buffer;
    }

    public String getInput() {
        return this.buffer.substring(this.start, this.stop);
    }

    public int getLength() {
        return this.stop - this.start;
    }

    public int getStart() {
        return this.start;
    }

    public int getStop() {
        return this.stop;
    }

    public <T> T getValue() {
        return (T)this.value;
    }

    public int getLine() {
        return Token.lineAndColumnOf(this.buffer, this.start)[0];
    }

    public int getColumn() {
        return Token.lineAndColumnOf(this.buffer, this.start)[1];
    }

    public String toString() {
        int[] tuple = Token.lineAndColumnOf(this.buffer, this.start);
        return "Token[" + tuple[0] + ":" + tuple[1] + "]: " + this.value;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        Token token = (Token)other;
        if (this.start != token.start) {
            return false;
        }
        if (this.stop != token.stop) {
            return false;
        }
        if (!Objects.equals(this.buffer, token.buffer)) {
            return false;
        }
        return Objects.equals(this.value, token.value);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.buffer, this.start, this.stop);
    }

    public static int[] lineAndColumnOf(String buffer, int position) {
        List tokens = NEWLINE_PARSER.token().matchesSkipping(buffer);
        int line = 1;
        int offset = 0;
        for (Token token : tokens) {
            if (position < token.stop) {
                return new int[]{line, position - offset + 1};
            }
            ++line;
            offset = token.stop;
        }
        return new int[]{line, position - offset + 1};
    }
}

