/*
 * Decompiled with CFR 0.152.
 */
package org.petitparser.parser.combinators;

import java.util.Objects;
import org.petitparser.context.Context;
import org.petitparser.context.Result;
import org.petitparser.parser.Parser;
import org.petitparser.parser.combinators.DelegateParser;

public class NotParser
extends DelegateParser {
    protected final String message;

    public NotParser(Parser delegate, String message) {
        super(delegate);
        this.message = Objects.requireNonNull(message, "Undefined message");
    }

    @Override
    public Result parseOn(Context context) {
        Result result = this.delegate.parseOn(context);
        if (result.isFailure()) {
            return context.success(null);
        }
        return context.failure(this.message);
    }

    @Override
    protected boolean hasEqualProperties(Parser other) {
        return super.hasEqualProperties(other) && Objects.equals(this.message, ((NotParser)other).message);
    }

    @Override
    public NotParser copy() {
        return new NotParser(this.delegate, this.message);
    }

    @Override
    public String toString() {
        return super.toString() + "[" + this.message + "]";
    }
}

