/*
 * Decompiled with CFR 0.152.
 */
package org.petitparser.parser.primitive;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.petitparser.parser.primitive.CharacterPredicate;

class CharacterRange {
    static final Comparator<CharacterRange> CHARACTER_RANGE_COMPARATOR = Comparator.comparing(range -> Character.valueOf(range.start)).thenComparing(range -> Character.valueOf(range.stop));
    private final char start;
    private final char stop;

    static CharacterPredicate toCharacterPredicate(List<CharacterRange> ranges) {
        ArrayList<CharacterRange> sortedRanges = new ArrayList<CharacterRange>(ranges);
        sortedRanges.sort(CHARACTER_RANGE_COMPARATOR);
        ArrayList<CharacterRange> mergedRanges = new ArrayList<CharacterRange>();
        for (CharacterRange thisRange : sortedRanges) {
            if (mergedRanges.isEmpty()) {
                mergedRanges.add(thisRange);
                continue;
            }
            CharacterRange lastRange = (CharacterRange)mergedRanges.get(mergedRanges.size() - 1);
            if (lastRange.stop + '\u0001' >= thisRange.start) {
                CharacterRange characterRange = new CharacterRange(lastRange.start, thisRange.stop);
                mergedRanges.set(mergedRanges.size() - 1, characterRange);
                continue;
            }
            mergedRanges.add(thisRange);
        }
        if (mergedRanges.isEmpty()) {
            return CharacterPredicate.none();
        }
        if (mergedRanges.size() == 1) {
            CharacterRange characterRange = (CharacterRange)mergedRanges.get(0);
            return characterRange.start == characterRange.stop ? CharacterPredicate.of(characterRange.start) : CharacterPredicate.range(characterRange.start, characterRange.stop);
        }
        char[] starts = new char[mergedRanges.size()];
        char[] stops = new char[mergedRanges.size()];
        for (int i = 0; i < mergedRanges.size(); ++i) {
            starts[i] = ((CharacterRange)mergedRanges.get((int)i)).start;
            stops[i] = ((CharacterRange)mergedRanges.get((int)i)).stop;
        }
        return CharacterPredicate.ranges(starts, stops);
    }

    CharacterRange(char start, char stop) {
        this.start = start;
        this.stop = stop;
    }
}

