/*
 * Decompiled with CFR 0.152.
 */
package org.petitparser.tools;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.petitparser.parser.Parser;
import org.petitparser.parser.combinators.ChoiceParser;
import org.petitparser.parser.combinators.SequenceParser;
import org.petitparser.parser.primitive.FailureParser;

public class ExpressionBuilder {
    private final List<ExpressionGroup> groups = new ArrayList<ExpressionGroup>();

    public ExpressionGroup group() {
        ExpressionGroup group = new ExpressionGroup();
        this.groups.add(group);
        return group;
    }

    public Parser build() {
        Parser parser = FailureParser.withMessage("Highest priority group should define a primitive parser.");
        for (ExpressionGroup group : this.groups) {
            parser = group.build(parser);
        }
        return parser;
    }

    private static class ExpressionResult {
        final Object operator;
        final Function<Object, Object> action;

        private ExpressionResult(Object operator, Function<Object, Object> action) {
            this.operator = operator;
            this.action = action;
        }
    }

    public static class ExpressionGroup {
        private final List<Parser> primitives = new ArrayList<Parser>();
        private final List<Parser> prefix = new ArrayList<Parser>();
        private final List<Parser> postfix = new ArrayList<Parser>();
        private final List<Parser> right = new ArrayList<Parser>();
        private final List<Parser> left = new ArrayList<Parser>();

        public ExpressionGroup primitive(Parser parser) {
            this.primitives.add(parser);
            return this;
        }

        private Parser buildPrimitive(Parser inner) {
            return this.buildChoice(this.primitives, inner);
        }

        public ExpressionGroup prefix(Parser parser) {
            this.addTo(this.prefix, parser, Function.identity());
            return this;
        }

        public <T, R> ExpressionGroup prefix(Parser parser, Function<T, R> action) {
            this.addTo(this.prefix, parser, action);
            return this;
        }

        private Parser buildPrefix(Parser inner) {
            if (this.prefix.isEmpty()) {
                return inner;
            }
            SequenceParser sequence = new SequenceParser(this.buildChoice(this.prefix).star(), inner);
            return sequence.map(tuple -> {
                Object value = tuple.get(1);
                List tuples = (List)tuple.get(0);
                Collections.reverse(tuples);
                for (ExpressionResult result : tuples) {
                    value = result.action.apply(Arrays.asList(result.operator, value));
                }
                return value;
            });
        }

        public ExpressionGroup postfix(Parser parser) {
            this.addTo(this.postfix, parser, Function.identity());
            return this;
        }

        public <T, R> ExpressionGroup postfix(Parser parser, Function<T, R> action) {
            this.addTo(this.postfix, parser, action);
            return this;
        }

        private Parser buildPostfix(Parser inner) {
            if (this.postfix.isEmpty()) {
                return inner;
            }
            SequenceParser sequence = new SequenceParser(inner, this.buildChoice(this.postfix).star());
            return sequence.map(tuple -> {
                Object value = tuple.get(0);
                for (ExpressionResult result : (List)tuple.get(1)) {
                    value = result.action.apply(Arrays.asList(value, result.operator));
                }
                return value;
            });
        }

        public ExpressionGroup right(Parser parser) {
            this.addTo(this.right, parser, Function.identity());
            return this;
        }

        public <T, R> ExpressionGroup right(Parser parser, Function<T, R> action) {
            this.addTo(this.right, parser, action);
            return this;
        }

        private Parser buildRight(Parser inner) {
            if (this.right.isEmpty()) {
                return inner;
            }
            Parser sequence = inner.separatedBy(this.buildChoice(this.right));
            return sequence.map(innerSequence -> {
                Object result = innerSequence.get(innerSequence.size() - 1);
                for (int i = innerSequence.size() - 2; i > 0; i -= 2) {
                    ExpressionResult expressionResult = (ExpressionResult)innerSequence.get(i);
                    result = expressionResult.action.apply(Arrays.asList(innerSequence.get(i - 1), expressionResult.operator, result));
                }
                return result;
            });
        }

        public ExpressionGroup left(Parser parser) {
            this.addTo(this.left, parser, Function.identity());
            return this;
        }

        public <T, R> ExpressionGroup left(Parser parser, Function<T, R> action) {
            this.addTo(this.left, parser, action);
            return this;
        }

        private Parser buildLeft(Parser inner) {
            if (this.left.isEmpty()) {
                return inner;
            }
            Parser sequence = inner.separatedBy(this.buildChoice(this.left));
            return sequence.map(innerSequence -> {
                Object result = innerSequence.get(0);
                for (int i = 1; i < innerSequence.size(); i += 2) {
                    ExpressionResult expressionResult = (ExpressionResult)innerSequence.get(i);
                    result = expressionResult.action.apply(Arrays.asList(result, expressionResult.operator, innerSequence.get(i + 1)));
                }
                return result;
            });
        }

        private <T, R> void addTo(List<Parser> list, Parser parser, Function<T, R> action) {
            list.add(parser.map(operator -> new ExpressionResult(operator, action)));
        }

        private Parser buildChoice(List<Parser> parsers) {
            return this.buildChoice(parsers, null);
        }

        private Parser buildChoice(List<Parser> parsers, Parser otherwise) {
            if (parsers.isEmpty()) {
                return otherwise;
            }
            if (parsers.size() == 1) {
                return parsers.get(0);
            }
            return new ChoiceParser(parsers.toArray(new Parser[parsers.size()]));
        }

        private Parser build(Parser inner) {
            return this.buildLeft(this.buildRight(this.buildPostfix(this.buildPrefix(this.buildPrimitive(inner)))));
        }
    }
}

