/*
 * Decompiled with CFR 0.152.
 */
package com.github.pjfanning.poi.xssf.streaming;

import java.io.Serializable;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.util.CellAddress;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTRst;

class SerializableComment
implements Serializable {
    private static final long serialVersionUID = 7829136421241571165L;
    private String author;
    private CTRst ctRst;
    private String addressAsText;
    private transient CellAddress cellAddress;
    private boolean visible = true;

    public void setAddress(CellAddress address) {
        this.cellAddress = address;
        this.addressAsText = address.formatAsString();
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public int getColumn() {
        CellAddress address = this.getAddress();
        if (address == null) {
            throw new IllegalStateException("cell address not initialised");
        }
        return address.getColumn();
    }

    public int getRow() {
        CellAddress address = this.getAddress();
        if (address == null) {
            throw new IllegalStateException("cell address not initialised");
        }
        return address.getRow();
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public CellAddress getAddress() {
        if (this.cellAddress == null && this.addressAsText != null) {
            this.cellAddress = new CellAddress(this.addressAsText);
        }
        return this.cellAddress;
    }

    public void setAddress(int row, int col) {
        this.setAddress(new CellAddress(row, col));
    }

    public void setColumn(int col) {
        CellAddress address = this.getAddress();
        if (address == null) {
            throw new IllegalStateException("cell address not initialised");
        }
        this.setAddress(address.getRow(), col);
    }

    public void setRow(int row) {
        CellAddress address = this.getAddress();
        if (address == null) {
            throw new IllegalStateException("cell address not initialised");
        }
        this.setAddress(row, address.getColumn());
    }

    public XSSFRichTextString getString() {
        return new XSSFRichTextString(this.ctRst);
    }

    public void setString(RichTextString string) {
        if (!(string instanceof XSSFRichTextString)) {
            throw new IllegalArgumentException("Only XSSFRichTextString argument is supported");
        }
        this.ctRst = ((XSSFRichTextString)string).getCTRst();
    }

    public void setString(String text) {
        XSSFRichTextString rts = new XSSFRichTextString();
        rts.setString(text);
        this.setString((RichTextString)rts);
    }
}

