/*
 * Decompiled with CFR 0.152.
 */
package com.github.reinert.jjschema;

import com.github.reinert.jjschema.HyperSchemaGeneratorV4;
import com.github.reinert.jjschema.JsonSchemaGenerator;
import com.github.reinert.jjschema.JsonSchemaGeneratorV4;

public class SchemaGeneratorBuilder {
    private SchemaGeneratorBuilder() {
    }

    public static ConfigurationStep draftV4Schema() {
        return new ConfigurationStep(new JsonSchemaGeneratorV4());
    }

    public static ConfigurationStep draftV4HyperSchema() {
        return new ConfigurationStep(new HyperSchemaGeneratorV4(new JsonSchemaGeneratorV4()));
    }

    public static class ConfigurationStep {
        final JsonSchemaGenerator generator;

        ConfigurationStep(JsonSchemaGenerator generator) {
            this.generator = generator;
        }

        public ConfigurationStep setAutoPutSchemaVersion(boolean autoPutVersion) {
            this.generator.autoPutVersion = autoPutVersion;
            return this;
        }

        public ConfigurationStep sortProperties(boolean sortProperties) {
            this.generator.sortProperties = sortProperties;
            return this;
        }

        public ConfigurationStep processAnnotatedOnly(boolean processAnnotatedOnly) {
            this.generator.processAnnotatedOnly = processAnnotatedOnly;
            return this;
        }

        public ConfigurationStep processFieldsOnly(boolean processFieldsOnly) {
            this.generator.processFieldsOnly = processFieldsOnly;
            return this;
        }

        public final JsonSchemaGenerator build() {
            return this.generator;
        }
    }
}

