/*
 * Decompiled with CFR 0.152.
 */
package com.github.reinert.jjschema.v1;

import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.annotation.JsonManagedReference;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.reinert.jjschema.Attributes;
import com.github.reinert.jjschema.JJSchemaUtil;
import com.github.reinert.jjschema.ManagedReference;
import com.github.reinert.jjschema.Nullable;
import com.github.reinert.jjschema.SchemaIgnore;
import com.github.reinert.jjschema.SchemaIgnoreProperties;
import com.github.reinert.jjschema.v1.CustomSchemaWrapper;
import com.github.reinert.jjschema.v1.EmptySchemaWrapper;
import com.github.reinert.jjschema.v1.RefSchemaWrapper;
import com.github.reinert.jjschema.v1.SchemaWrapper;
import com.github.reinert.jjschema.v1.SchemaWrapperFactory;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;

public class PropertyWrapper
extends SchemaWrapper {
    static final String propertiesStr = "/properties/";
    static final String itemsStr = "/items";
    final CustomSchemaWrapper ownerSchemaWrapper;
    final SchemaWrapper schemaWrapper;
    final Field field;
    final Method method;
    String name;
    boolean required;
    ManagedReference managedReference;
    ReferenceType referenceType;

    public PropertyWrapper(CustomSchemaWrapper ownerSchemaWrapper, Set<ManagedReference> managedReferences, Method method, Field field) {
        super(null);
        SchemaWrapper schemaWrapperLocal;
        String relativeId;
        ParameterizedType p;
        if (method == null) {
            throw new RuntimeException("Error at " + ownerSchemaWrapper.getJavaType().getName() + ": Cannot instantiate a PropertyWrapper with a null method.");
        }
        this.ownerSchemaWrapper = ownerSchemaWrapper;
        this.field = field;
        this.method = method;
        Type genericType = method.getGenericReturnType();
        Class propertyType = method.getReturnType();
        Class<?> collectionType = null;
        if (genericType instanceof TypeVariable && (p = ownerSchemaWrapper.getParameterizedType()) != null) {
            int i = Arrays.asList(((Class)p.getRawType()).getTypeParameters()).indexOf(genericType);
            propertyType = (Class)p.getActualTypeArguments()[i];
        }
        if (Collection.class.isAssignableFrom(propertyType)) {
            collectionType = method.getReturnType();
            if (!(genericType instanceof ParameterizedType)) {
                genericType = collectionType.getGenericSuperclass();
                while (!(genericType instanceof ParameterizedType)) {
                    genericType = ((Class)genericType).getGenericSuperclass();
                }
            }
            propertyType = ((ParameterizedType)genericType).getActualTypeArguments()[0];
            relativeId = propertiesStr + this.getName() + itemsStr;
        } else {
            relativeId = propertiesStr + this.getName();
        }
        this.processReference(propertyType);
        if (this.shouldIgnoreField()) {
            this.schemaWrapper = new EmptySchemaWrapper();
        } else if (this.getReferenceType() == ReferenceType.BACKWARD) {
            String id = this.processId(method.getReturnType());
            if (id != null) {
                schemaWrapperLocal = new RefSchemaWrapper(propertyType, id);
                ownerSchemaWrapper.pushReference(this.getManagedReference());
            } else if (ownerSchemaWrapper.pushReference(this.getManagedReference())) {
                String relativeId1 = ownerSchemaWrapper.getRelativeId();
                relativeId1 = relativeId1.endsWith(itemsStr) ? relativeId1.substring(0, relativeId1.substring(0, relativeId1.length() - itemsStr.length()).lastIndexOf("/") - (propertiesStr.length() - 1)) : relativeId1.substring(0, relativeId1.lastIndexOf("/") - (propertiesStr.length() - 1));
                schemaWrapperLocal = new RefSchemaWrapper(propertyType, relativeId1);
            } else {
                schemaWrapperLocal = new EmptySchemaWrapper();
            }
            this.schemaWrapper = schemaWrapperLocal.isRefWrapper() && collectionType != null ? SchemaWrapperFactory.createArrayRefWrapper((RefSchemaWrapper)schemaWrapperLocal) : schemaWrapperLocal;
        } else if (ownerSchemaWrapper.getJavaType() == propertyType) {
            schemaWrapperLocal = new RefSchemaWrapper(propertyType, ownerSchemaWrapper.getRelativeId());
            this.schemaWrapper = collectionType != null ? SchemaWrapperFactory.createArrayRefWrapper((RefSchemaWrapper)schemaWrapperLocal) : schemaWrapperLocal;
        } else {
            if (this.getReferenceType() == ReferenceType.FORWARD) {
                ownerSchemaWrapper.pullReference(this.getManagedReference());
            }
            String relativeId1 = ownerSchemaWrapper.getRelativeId() + relativeId;
            this.schemaWrapper = collectionType != null ? this.createArrayWrapper(managedReferences, propertyType, collectionType, relativeId1) : (genericType instanceof ParameterizedType ? this.createWrapper(managedReferences, genericType, relativeId) : this.createWrapper(managedReferences, propertyType, relativeId1));
            this.processAttributes(this.getNode(), this.getAccessibleObject());
            this.processNullable();
        }
    }

    public Field getField() {
        return this.field;
    }

    public Method getMethod() {
        return this.method;
    }

    public SchemaWrapper getOwnerSchema() {
        return this.ownerSchemaWrapper;
    }

    public String getName() {
        if (this.name == null) {
            this.name = this.processPropertyName();
        }
        return this.name;
    }

    public boolean isRequired() {
        return this.required;
    }

    public ManagedReference getManagedReference() {
        return this.managedReference;
    }

    public ReferenceType getReferenceType() {
        return this.referenceType;
    }

    public boolean isReference() {
        return this.managedReference != null;
    }

    @Override
    public JsonNode asJson() {
        return this.schemaWrapper.asJson();
    }

    @Override
    public String getDollarSchema() {
        return this.schemaWrapper.getDollarSchema();
    }

    @Override
    public String getId() {
        return this.schemaWrapper.getId();
    }

    @Override
    public String getRef() {
        return this.schemaWrapper.getRef();
    }

    @Override
    public String getType() {
        return this.schemaWrapper.getType();
    }

    @Override
    public Class<?> getJavaType() {
        return this.schemaWrapper.getJavaType();
    }

    @Override
    public boolean isEnumWrapper() {
        return this.schemaWrapper.isEnumWrapper();
    }

    @Override
    public boolean isSimpleWrapper() {
        return this.schemaWrapper.isSimpleWrapper();
    }

    @Override
    public boolean isCustomWrapper() {
        return this.schemaWrapper.isCustomWrapper();
    }

    @Override
    public boolean isRefWrapper() {
        return this.schemaWrapper.isRefWrapper();
    }

    @Override
    public boolean isArrayWrapper() {
        return this.schemaWrapper.isArrayWrapper();
    }

    @Override
    public boolean isNullWrapper() {
        return this.schemaWrapper.isNullWrapper();
    }

    @Override
    public boolean isEmptyWrapper() {
        return this.schemaWrapper.isEmptyWrapper();
    }

    @Override
    public <T extends SchemaWrapper> T cast() {
        return this.schemaWrapper.cast();
    }

    protected SchemaWrapper createWrapper(Set<ManagedReference> managedReferences, Type genericType, String relativeId1) {
        return SchemaWrapperFactory.createWrapper(genericType, managedReferences, relativeId1, this.shouldIgnoreProperties());
    }

    protected SchemaWrapper createArrayWrapper(Set<ManagedReference> managedReferences, Type propertyType, Class<?> collectionType, String relativeId1) {
        return SchemaWrapperFactory.createArrayWrapper(collectionType, propertyType, managedReferences, relativeId1, this.shouldIgnoreProperties());
    }

    protected void setRequired(boolean required) {
        this.required = required;
    }

    protected AccessibleObject getAccessibleObject() {
        return this.field == null ? this.method : this.field;
    }

    protected String processId(Class<?> accessibleObject) {
        Attributes attributes = accessibleObject.getAnnotation(Attributes.class);
        if (attributes != null && !attributes.id().isEmpty()) {
            return attributes.id();
        }
        return null;
    }

    protected void processAttributes(ObjectNode node, AccessibleObject accessibleObject) {
        Attributes attributes = accessibleObject.getAnnotation(Attributes.class);
        if (attributes != null) {
            node.remove("$schema");
            JJSchemaUtil.processCommonAttributes(node, attributes);
            if (attributes.required()) {
                this.setRequired(true);
            }
        }
    }

    protected void processReference(Type propertyType) {
        JsonBackReference backRefAnn;
        boolean referenceExists = false;
        JsonManagedReference refAnn = this.getAccessibleObject().getAnnotation(JsonManagedReference.class);
        if (refAnn != null) {
            referenceExists = true;
            this.managedReference = new ManagedReference(this.getOwnerSchema().getJavaType(), refAnn.value(), propertyType);
            this.referenceType = ReferenceType.FORWARD;
        }
        if ((backRefAnn = this.getAccessibleObject().getAnnotation(JsonBackReference.class)) != null) {
            if (referenceExists) {
                throw new RuntimeException("Error at " + this.getOwnerSchema().getJavaType().getName() + ": Cannot reference " + propertyType.getTypeName() + " both as Managed and Back Reference.");
            }
            this.managedReference = new ManagedReference(propertyType, backRefAnn.value(), this.getOwnerSchema().getJavaType());
            this.referenceType = ReferenceType.BACKWARD;
        }
    }

    @Override
    protected ObjectNode getNode() {
        return this.schemaWrapper.getNode();
    }

    @Override
    protected void processNullable() {
        Nullable nullable = this.getAccessibleObject().getAnnotation(Nullable.class);
        if (nullable != null) {
            if (this.isEnumWrapper()) {
                ((ArrayNode)this.getNode().get("enum")).addNull();
            } else {
                String oldType = this.getType();
                ArrayNode typeArray = this.getNode().putArray("type");
                typeArray.add(oldType);
                typeArray.add("null");
            }
        }
    }

    @Override
    protected String getNodeTextValue(JsonNode node) {
        return this.schemaWrapper.getNodeTextValue(node);
    }

    @Override
    protected void setType(String type) {
        this.schemaWrapper.setType(type);
    }

    private String processPropertyName() {
        if (this.field != null) {
            if (this.field.isAnnotationPresent(JsonProperty.class)) {
                return this.field.getAnnotation(JsonProperty.class).value();
            }
            return this.field.getName();
        }
        if ("get".equals(this.method.getName())) {
            return "get";
        }
        return this.firstToLowerCase(this.method.getName().replace("get", ""));
    }

    private String firstToLowerCase(String string) {
        return Character.toLowerCase(string.charAt(0)) + (string.length() > 1 ? string.substring(1) : "");
    }

    protected boolean shouldIgnoreField() {
        return this.getAccessibleObject().getAnnotation(SchemaIgnore.class) != null;
    }

    protected boolean shouldIgnoreProperties() {
        return this.getAccessibleObject().getAnnotation(SchemaIgnoreProperties.class) != null;
    }

    static enum ReferenceType {
        NONE,
        FORWARD,
        BACKWARD;

    }
}

