/*
 * Decompiled with CFR 0.152.
 */
package com.github.reinert.jjschema.v1;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.reinert.jjschema.ManagedReference;
import com.github.reinert.jjschema.SimpleTypeMappings;
import com.github.reinert.jjschema.v1.ArraySchemaWrapper;
import com.github.reinert.jjschema.v1.CustomSchemaWrapper;
import com.github.reinert.jjschema.v1.EnumSchemaWrapper;
import com.github.reinert.jjschema.v1.NullSchemaWrapper;
import com.github.reinert.jjschema.v1.RefSchemaWrapper;
import com.github.reinert.jjschema.v1.SchemaWrapper;
import com.github.reinert.jjschema.v1.SimpleSchemaWrapper;
import java.lang.reflect.Type;
import java.util.AbstractCollection;
import java.util.Set;

public class SchemaWrapperFactory {
    public static final ObjectMapper MAPPER = new ObjectMapper();

    private SchemaWrapperFactory() {
    }

    public static SchemaWrapper createWrapper(Type propertyType) {
        return SchemaWrapperFactory.createWrapper(propertyType, null);
    }

    public static SchemaWrapper createArrayWrapper(Class<?> type, Class<?> parametrizedType, boolean ignoreProperties) {
        return new ArraySchemaWrapper(type, parametrizedType, ignoreProperties);
    }

    public static SchemaWrapper createWrapper(Type propertyType, Set<ManagedReference> managedReferences) {
        return SchemaWrapperFactory.createWrapper(propertyType, managedReferences, null, false);
    }

    public static SchemaWrapper createWrapper(Type type, Set<ManagedReference> managedReferences, String relativeId, boolean ignoreProperties) {
        if (type == Void.class || type == Void.TYPE || type == null) {
            return new NullSchemaWrapper(type);
        }
        if (SimpleTypeMappings.isSimpleType(type)) {
            return new SimpleSchemaWrapper(type);
        }
        if (type instanceof Class && ((Class)type).isEnum()) {
            return new EnumSchemaWrapper((Class)type);
        }
        if (managedReferences != null) {
            if (relativeId != null) {
                return new CustomSchemaWrapper(type, managedReferences, relativeId, ignoreProperties);
            }
            return new CustomSchemaWrapper(type, managedReferences, ignoreProperties);
        }
        return new CustomSchemaWrapper(type, ignoreProperties);
    }

    public static SchemaWrapper createArrayWrapper(Class<?> type, Class<?> parametrizedType, Set<ManagedReference> managedReferences, boolean ignoreProperties) {
        return new ArraySchemaWrapper(type, parametrizedType, managedReferences, ignoreProperties);
    }

    public static SchemaWrapper createArrayWrapper(Class<?> type, Type propertyType, Set<ManagedReference> managedReferences, String relativeId, boolean ignoreProperties) {
        return new ArraySchemaWrapper(type, propertyType, managedReferences, relativeId, ignoreProperties);
    }

    public static SchemaWrapper createArrayRefWrapper(RefSchemaWrapper refSchemaWrapper) {
        return new ArraySchemaWrapper(AbstractCollection.class, refSchemaWrapper);
    }
}

