/*
 * Decompiled with CFR 0.152.
 */
package com.rinoto.migramongo.spring.jmx;

import com.google.gson.Gson;
import com.rinoto.migramongo.MigraMongo;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedResource;

@ManagedResource
public class MigraMongoJMX {
    private final MigraMongo migraMongo;
    private Gson gson;

    public MigraMongoJMX(MigraMongo migraMongo) {
        this.migraMongo = migraMongo;
    }

    @ManagedOperation
    public String migrate() {
        return this.toJson(this.migraMongo.migrate());
    }

    @ManagedOperation
    public String migrateAsync() {
        return this.toJson(this.migraMongo.migrateAsync());
    }

    @ManagedOperation
    public String dryRun() {
        return this.toJson(this.migraMongo.dryRun());
    }

    @ManagedOperation
    public String status(String fromVersion) {
        return this.toJson(this.migraMongo.status(fromVersion));
    }

    @ManagedOperation
    public Boolean needsMigration() {
        return !this.migraMongo.dryRun().migrationsApplied.isEmpty();
    }

    @ManagedOperation
    public String history() {
        return this.toJson(this.migraMongo.getMigrationEntries());
    }

    @ManagedOperation
    public void destroyLocks() {
        this.migraMongo.destroyLocks();
    }

    private String toJson(Object obj) {
        return this.getGson().toJson(obj);
    }

    private Gson getGson() {
        if (this.gson == null) {
            this.gson = new Gson();
        }
        return this.gson;
    }
}

