/*
 * Decompiled with CFR 0.152.
 */
package com.github.searls.jasmine.driver;

import com.github.searls.jasmine.driver.QuietHtmlUnitDriver;
import com.github.searls.jasmine.mojo.Capability;
import com.google.common.base.Objects;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.List;
import org.codehaus.plexus.util.StringUtils;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.openqa.selenium.remote.DesiredCapabilities;

public class WebDriverFactory {
    private boolean debug;
    private String browserVersion;
    private String webDriverClassName;
    private List<Capability> webDriverCapabilities;

    public WebDriverFactory() {
        this.setWebDriverCapabilities(null);
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setBrowserVersion(String browserVersion) {
        this.browserVersion = browserVersion;
    }

    public void setWebDriverClassName(String webDriverClassName) {
        this.webDriverClassName = webDriverClassName;
    }

    public void setWebDriverCapabilities(List<Capability> webDriverCapabilities) {
        this.webDriverCapabilities = (List)Objects.firstNonNull(webDriverCapabilities, Collections.emptyList());
    }

    public WebDriver createWebDriver() throws Exception {
        if (HtmlUnitDriver.class.getName().equals(this.webDriverClassName)) {
            return this.createDefaultWebDriver();
        }
        return this.createCustomWebDriver();
    }

    private Class<? extends WebDriver> getWebDriverClass() throws Exception {
        return Class.forName(this.webDriverClassName);
    }

    private Constructor<? extends WebDriver> getWebDriverConstructor() throws Exception {
        Class<? extends WebDriver> webDriverClass = this.getWebDriverClass();
        boolean hasCapabilities = !this.webDriverCapabilities.isEmpty();
        try {
            if (hasCapabilities) {
                return webDriverClass.getConstructor(Capabilities.class);
            }
            return webDriverClass.getConstructor(new Class[0]);
        }
        catch (Exception exception) {
            if (hasCapabilities) {
                return webDriverClass.getConstructor(new Class[0]);
            }
            return webDriverClass.getConstructor(Capabilities.class);
        }
    }

    private WebDriver createCustomWebDriver() throws Exception {
        Constructor<? extends WebDriver> constructor = this.getWebDriverConstructor();
        return constructor.newInstance(this.getWebDriverConstructorArguments(constructor));
    }

    private Object[] getWebDriverConstructorArguments(Constructor<? extends WebDriver> constructor) {
        if (constructor.getParameterTypes().length == 0) {
            return new Object[0];
        }
        return new Object[]{this.getCapabilities()};
    }

    private DesiredCapabilities getCapabilities() {
        DesiredCapabilities capabilities = new DesiredCapabilities();
        capabilities.setJavascriptEnabled(true);
        for (Capability capability : this.webDriverCapabilities) {
            Object value = capability.getValue();
            if (value != null && (!String.class.isInstance(value) || StringUtils.isNotBlank((String)((String)value)))) {
                capabilities.setCapability(capability.getName(), capability.getValue());
                continue;
            }
            if (capability.getList() != null && !capability.getList().isEmpty()) {
                capabilities.setCapability(capability.getName(), capability.getList());
                continue;
            }
            if (capability.getMap() == null || capability.getMap().isEmpty()) continue;
            capabilities.setCapability(capability.getName(), capability.getMap());
        }
        return capabilities;
    }

    private WebDriver createDefaultWebDriver() throws Exception {
        DesiredCapabilities capabilities = this.getCapabilities();
        if (StringUtils.isBlank((String)capabilities.getBrowserName())) {
            capabilities.setBrowserName("htmlunit");
        }
        if (StringUtils.isBlank((String)capabilities.getVersion())) {
            capabilities.setVersion(this.browserVersion.replaceAll("(\\D+)_(\\d.*)?", "$1-$2").replaceAll("_", " ").toLowerCase());
        }
        return new QuietHtmlUnitDriver((Capabilities)this.getCapabilities(), this.debug);
    }
}

