/*
 * Decompiled with CFR 0.152.
 */
package com.github.seratch.jslack.api.status.v1.impl;

import com.github.seratch.jslack.api.status.v1.LegacyStatusApiException;
import com.github.seratch.jslack.api.status.v1.LegacyStatusClient;
import com.github.seratch.jslack.api.status.v1.model.LegacyCurrentStatus;
import com.github.seratch.jslack.api.status.v1.model.LegacySlackIssue;
import com.github.seratch.jslack.common.http.SlackHttpClient;
import com.github.seratch.jslack.common.json.GsonFactory;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import okhttp3.Response;

public class LegacyStatusClientImpl
implements LegacyStatusClient {
    private String endpointUrlPrefix = "https://status.slack.com/api/v1.0.0/";
    private final SlackHttpClient slackHttpClient;

    public LegacyStatusClientImpl(SlackHttpClient slackHttpClient) {
        this.slackHttpClient = slackHttpClient;
    }

    @Override
    public String getEndpointUrlPrefix() {
        return this.endpointUrlPrefix;
    }

    @Override
    public void setEndpointUrlPrefix(String endpointUrlPrefix) {
        this.endpointUrlPrefix = endpointUrlPrefix;
    }

    @Override
    public LegacyCurrentStatus current() throws IOException, LegacyStatusApiException {
        Response response = this.slackHttpClient.get(this.endpointUrlPrefix + "current", null, null);
        String body = response.body().string();
        this.slackHttpClient.runHttpResponseListeners(response, body);
        if (response.isSuccessful()) {
            return (LegacyCurrentStatus)GsonFactory.createSnakeCase(this.slackHttpClient.getConfig()).fromJson(body, LegacyCurrentStatus.class);
        }
        throw new LegacyStatusApiException(response, body);
    }

    @Override
    public List<LegacySlackIssue> history() throws IOException, LegacyStatusApiException {
        Response response = this.slackHttpClient.get(this.endpointUrlPrefix + "history", null, null);
        Type listType = new TypeToken<ArrayList<LegacySlackIssue>>(){}.getType();
        String body = response.body().string();
        this.slackHttpClient.runHttpResponseListeners(response, body);
        if (response.isSuccessful()) {
            return (List)GsonFactory.createSnakeCase(this.slackHttpClient.getConfig()).fromJson(body, listType);
        }
        throw new LegacyStatusApiException(response, body);
    }
}

