/*
 * Decompiled with CFR 0.152.
 */
package slib.graph.algo.extraction.reduction.dag;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openrdf.model.URI;
import org.openrdf.model.vocabulary.RDFS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import slib.graph.algo.traversal.classical.DFS;
import slib.graph.algo.validator.dag.ValidatorDAG;
import slib.graph.model.graph.G;
import slib.graph.model.graph.elements.E;
import slib.graph.model.graph.utils.Direction;
import slib.graph.model.graph.utils.WalkConstraint;
import slib.graph.utils.WalkConstraintGeneric;
import slib.utils.ex.SLIB_Ex_Critic;
import slib.utils.impl.SetUtils;

public class GraphReduction_Transitive {
    static Logger logger = LoggerFactory.getLogger(GraphReduction_Transitive.class);

    public static Set<E> process(G graph) throws SLIB_Ex_Critic {
        ValidatorDAG validator;
        int selfLoops = 0;
        for (E e : graph.getE(RDFS.SUBCLASSOF)) {
            if (!e.getSource().equals((Object)e.getTarget())) continue;
            graph.removeE(e);
            ++selfLoops;
        }
        if (selfLoops != 0) {
            logger.info(selfLoops + " self loops have been removed");
        }
        if (!(validator = new ValidatorDAG()).containsTaxonomicDag(graph)) {
            throw new SLIB_Ex_Critic("Transitive reduction on taxonomic graph requires an underlying DAG to be defined");
        }
        Set<URI> roots = new ValidatorDAG().getTaxonomicRoots(graph);
        logger.info("Transitive reduction considering " + roots.size() + " root(s)");
        logger.debug("roots: " + roots);
        return GraphReduction_Transitive.process(graph, roots);
    }

    public static Set<E> process(G g, Set<URI> srcs) {
        HashSet<E> removableEdges = new HashSet<E>();
        logger.info("Processing transitive reduction: ");
        logger.debug("Number of roots" + srcs.size() + " root(s)");
        logger.debug("roots: " + srcs);
        WalkConstraintGeneric wc = new WalkConstraintGeneric(RDFS.SUBCLASSOF, Direction.IN);
        DFS dfs = new DFS(g, srcs, (WalkConstraint)wc);
        List<URI> topoOrder = dfs.getTraversalOrder();
        HashMap reachableV = new HashMap();
        for (int i = topoOrder.size() - 1; i >= 0; --i) {
            URI currentV = topoOrder.get(i);
            if (!reachableV.containsKey(currentV)) {
                reachableV.put(currentV, new HashSet());
            }
            ((HashSet)reachableV.get(currentV)).add(currentV);
            Set edges = g.getE(RDFS.SUBCLASSOF, currentV, Direction.IN);
            for (E e : edges) {
                URI target = e.getSource();
                if (!reachableV.containsKey(target)) {
                    reachableV.put(target, new HashSet());
                    ((HashSet)reachableV.get(target)).addAll((Collection)reachableV.get(currentV));
                    continue;
                }
                Set inter = SetUtils.intersection((Collection)((Collection)reachableV.get(target)), (Collection)((Collection)reachableV.get(currentV)));
                Set outTarget = g.getE(RDFS.SUBCLASSOF, target, Direction.OUT);
                for (E eTarget : outTarget) {
                    if (!inter.contains(eTarget.getTarget())) continue;
                    removableEdges.add(eTarget);
                }
                ((HashSet)reachableV.get(target)).addAll((Collection)reachableV.get(currentV));
            }
        }
        g.removeE(removableEdges);
        if (logger.isDebugEnabled()) {
            for (E e : removableEdges) {
                logger.debug("TODEL : " + e);
            }
        }
        logger.info("Deletion of " + removableEdges.size() + " subClassOf relationships");
        return removableEdges;
    }
}

