/*
 * Decompiled with CFR 0.152.
 */
package slib.graph.algo.extraction.shortest_path;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.openrdf.model.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import slib.graph.model.graph.G;
import slib.graph.model.graph.elements.E;
import slib.graph.model.graph.utils.WalkConstraint;
import slib.graph.model.graph.weight.GWS;
import slib.utils.ex.SLIB_Ex_Critic;

public class Dijkstra {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    G g;
    WalkConstraint walkConstraints;
    GWS ws = null;
    public static final Double NOT_COMPUTED = -1.0;

    private void checkGWSisNonNegative() throws SLIB_Ex_Critic {
        if (this.ws != null) {
            for (E e : this.g.getE(this.walkConstraints.getAcceptedPredicates())) {
                if (!(this.ws.getWeight(e) < 0.0)) continue;
                throw new SLIB_Ex_Critic("Dijkstra algorithm cannot be used for a weighting scheme composed of negative weight");
            }
        }
    }

    public Dijkstra(G g, WalkConstraint walconstraints) throws SLIB_Ex_Critic {
        this.g = g;
        this.walkConstraints = walconstraints;
        this.ws = null;
    }

    public Dijkstra(G g, WalkConstraint walconstraints, GWS weightingScheme) throws SLIB_Ex_Critic {
        this.g = g;
        this.walkConstraints = walconstraints;
        this.ws = weightingScheme;
        this.checkGWSisNonNegative();
    }

    public Double shortestPath(URI source, URI t) {
        this.logger.debug("\tComputing Shortest path... from " + source + " to " + t + " " + this.ws);
        HashMap<URI, Double> dists = new HashMap<URI, Double>();
        HashMap<URI, Boolean> visited = new HashMap<URI, Boolean>();
        for (URI v : this.g.getV()) {
            dists.put(v, NOT_COMPUTED);
            visited.put(v, false);
        }
        dists.put(source, 0.0);
        for (int i = 0; i < dists.size(); ++i) {
            URI next;
            if (dists.size() >= 1000 && i % 1000 == 0) {
                this.logger.info("\tComputing Shortest path... Step " + i + "/" + dists.size());
            }
            if ((next = this.minVertex(dists, visited)) == null) break;
            if (next == t) {
                return dists.get(t);
            }
            visited.put(next, true);
            Set edges = this.g.getE(next, this.walkConstraints);
            for (E e : edges) {
                Double d = dists.get(next) + (this.ws == null ? 1.0 : this.ws.getWeight(e));
                URI target = e.getTarget();
                if (!target.equals((Object)next)) {
                    if (dists.get(target) != NOT_COMPUTED && !(dists.get(target) > d)) continue;
                    dists.put(target, d);
                    continue;
                }
                URI src = e.getSource();
                if (dists.get(src) != NOT_COMPUTED && !(dists.get(src) > d)) continue;
                dists.put(src, d);
            }
        }
        return (Double)dists.get(t);
    }

    public ConcurrentHashMap<URI, Double> shortestPath(URI source) {
        this.logger.debug("\tComputing Shortest path... from " + source + "  " + this.ws);
        ConcurrentHashMap<URI, Double> dists = new ConcurrentHashMap<URI, Double>();
        ConcurrentHashMap<URI, Boolean> visited = new ConcurrentHashMap<URI, Boolean>();
        for (URI v : this.g.getV()) {
            dists.put(v, NOT_COMPUTED);
            visited.put(v, false);
        }
        dists.put(source, new Double(0.0));
        for (int i = 0; i < dists.size(); ++i) {
            URI next;
            if (dists.size() >= 1000 && i % 1000 == 0) {
                this.logger.debug("\tComputing Shortest from " + source + " paths... Step " + i + "/" + dists.size());
            }
            if ((next = this.minVertex(dists, visited)) == null) break;
            visited.put(next, true);
            Set edges = this.g.getE(next, this.walkConstraints);
            for (E e : edges) {
                Double d = dists.get(next) + (this.ws == null ? 1.0 : this.ws.getWeight(e));
                URI target = e.getTarget();
                if (!target.equals((Object)next)) {
                    if (dists.get(target) != NOT_COMPUTED && !(dists.get(target) > d)) continue;
                    dists.put(target, d);
                    continue;
                }
                URI src = e.getSource();
                if (dists.get(src) != NOT_COMPUTED && !(dists.get(src) > d)) continue;
                dists.put(src, d);
            }
        }
        return dists;
    }

    private URI minVertex(Map<URI, Double> dist, Map<URI, Boolean> visited) {
        Double x = Double.MAX_VALUE;
        URI next = null;
        for (URI v : dist.keySet()) {
            if (visited.get(v).booleanValue() || dist.get(v) == NOT_COMPUTED || !(dist.get(v) < x)) continue;
            next = v;
            x = dist.get(v);
        }
        return next;
    }
}

