/*
 * Decompiled with CFR 0.152.
 */
package slib.graph.algo.extraction.utils;

import java.util.Set;
import org.openrdf.model.URI;
import org.openrdf.model.vocabulary.RDFS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import slib.graph.algo.validator.dag.ValidatorDAG;
import slib.graph.model.graph.G;
import slib.graph.model.graph.utils.Direction;
import slib.graph.model.graph.utils.WalkConstraint;
import slib.graph.utils.WalkConstraintGeneric;
import slib.utils.ex.SLIB_Ex_Critic;

public class RooterDAG {
    public static URI rootUnderlyingDAG(G g, URI rootUri, WalkConstraint wc, boolean checkUnderlyingDAG) throws SLIB_Ex_Critic {
        URI rootURI_;
        Logger logger = LoggerFactory.getLogger(RooterDAG.class);
        ValidatorDAG validator = new ValidatorDAG();
        if (checkUnderlyingDAG && !validator.isDag(g, wc)) {
            throw new SLIB_Ex_Critic("Error during rerooting: Underlying graph build from  contraint " + wc + "" + "is not a DAG");
        }
        Set<URI> roots = new ValidatorDAG().getDAGRoots(g, wc);
        int nbRoot = roots.size();
        if (nbRoot == 1) {
            logger.info("Rooting skipped : Graph already rooted");
            rootURI_ = roots.iterator().next();
        } else {
            logger.info("Number of roots detected: " + roots.size());
            g.addV(rootUri);
            if (roots.contains(rootUri)) {
                roots.remove(rootUri);
            }
            rootURI_ = rootUri;
            long c = 0L;
            for (URI v : roots) {
                ++c;
                g.addE(v, RDFS.SUBCLASSOF, rootUri);
            }
            logger.info("Rooting performed using " + rootURI_ + " as root " + c + " edges created");
            logger.debug(" Contains Rooted taxonomic DAG " + validator.containsTaxonomicDagWithUniqueRoot(g));
        }
        return rootURI_;
    }

    public static URI rootUnderlyingTaxonomicDAG(G g, URI rootUri) throws SLIB_Ex_Critic {
        Logger logger = LoggerFactory.getLogger(RooterDAG.class);
        logger.info("Rooting taxonomic Graph using " + rootUri);
        ValidatorDAG validator = new ValidatorDAG();
        if (!validator.containsTaxonomicDagWithUniqueRoot(g)) {
            return RooterDAG.rootUnderlyingDAG(g, rootUri, (WalkConstraint)new WalkConstraintGeneric(RDFS.SUBCLASSOF, Direction.OUT), true);
        }
        return validator.getUniqueTaxonomicRoot(g);
    }
}

