/*
 * Decompiled with CFR 0.152.
 */
package slib.graph.algo.metric;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.openrdf.model.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import slib.graph.model.graph.G;
import slib.graph.model.graph.elements.E;
import slib.graph.model.graph.utils.Direction;
import slib.graph.model.graph.utils.WalkConstraint;
import slib.graph.utils.WalkConstraintUtils;
import slib.utils.ex.SLIB_Ex_Critic;
import slib.utils.ex.SLIB_Exception;

public class DepthAnalyserAG {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    G g;
    WalkConstraint wc;

    public DepthAnalyserAG(G g, WalkConstraint wc) {
        this.wc = wc;
        this.g = g;
    }

    private Map<URI, Integer> getVDepths(boolean max) throws SLIB_Ex_Critic {
        HashMap<URI, Integer> computedDepths = new HashMap<URI, Integer>();
        HashMap<URI, Integer> inDegree = new HashMap<URI, Integer>();
        HashMap<URI, Integer> inDegreeDone = new HashMap<URI, Integer>();
        ArrayList<URI> queue = new ArrayList<URI>();
        this.logger.debug("Walk constraint loaded " + this.wc);
        WalkConstraint wcOpp = WalkConstraintUtils.getInverse((WalkConstraint)this.wc, (boolean)false);
        this.logger.debug("Building initial queue considering inverse constraint " + wcOpp);
        for (URI v : this.g.getV()) {
            int sizeOpposite = this.g.getE(v, wcOpp).size();
            computedDepths.put(v, 0);
            inDegree.put(v, sizeOpposite);
            inDegreeDone.put(v, 0);
            if (sizeOpposite != 0) continue;
            queue.add(v);
        }
        this.logger.debug("Queue size " + queue.size());
        while (!queue.isEmpty()) {
            URI current = (URI)queue.get(0);
            queue.remove(0);
            Set edges = this.g.getE(current, this.wc);
            int currentDepth = (Integer)computedDepths.get(current) + 1;
            for (E e : edges) {
                Direction dir = this.wc.getAssociatedDirection(e.getURI());
                URI dest = e.getTarget();
                if (dir == Direction.IN) {
                    dest = e.getSource();
                }
                int done = (Integer)inDegreeDone.get(dest) + 1;
                inDegreeDone.put(dest, done);
                if ((Integer)computedDepths.get(dest) == 0) {
                    computedDepths.put(dest, currentDepth);
                } else {
                    int computedDepth = (Integer)computedDepths.get(dest);
                    if (max) {
                        if (computedDepth < currentDepth) {
                            computedDepths.put(dest, currentDepth);
                        }
                    } else if (computedDepth > currentDepth) {
                        computedDepths.put(dest, currentDepth);
                    }
                }
                if (done != (Integer)inDegree.get(dest)) continue;
                queue.add(dest);
            }
        }
        return computedDepths;
    }

    public Map<URI, Integer> getVMaxDepths() throws SLIB_Ex_Critic {
        this.logger.debug("Computing max depths...");
        return this.getVDepths(true);
    }

    public Map<URI, Integer> getVMinDepths() throws SLIB_Ex_Critic {
        this.logger.debug("Computing min depths...");
        return this.getVDepths(false);
    }

    public Map<Integer, Integer> getMinDepthsDistribution() throws SLIB_Exception {
        Map<URI, Integer> allDepths = this.getVMinDepths();
        Map<Integer, Integer> distribution = this.getDistribution(allDepths);
        return distribution;
    }

    public Map<Integer, Integer> getMaxDepthsDistribution() throws SLIB_Exception {
        Map<URI, Integer> allDepths = this.getVMaxDepths();
        Map<Integer, Integer> distribution = this.getDistribution(allDepths);
        return distribution;
    }

    private <N extends Number> Map<N, Integer> getDistribution(Map<URI, N> depths) {
        HashMap<Number, Integer> distribution = new HashMap<Number, Integer>();
        for (Map.Entry<URI, N> entry : depths.entrySet()) {
            Number cDepth = (Number)entry.getValue();
            Integer nbV = (Integer)distribution.get(cDepth);
            if (nbV == null) {
                distribution.put(cDepth, 1);
                continue;
            }
            distribution.put(cDepth, nbV + 1);
        }
        return distribution;
    }
}

