/*
 * Decompiled with CFR 0.152.
 */
package slib.graph.algo.traversal.classical;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openrdf.model.URI;
import slib.graph.algo.traversal.GraphTraversal;
import slib.graph.model.graph.G;
import slib.graph.model.graph.utils.WalkConstraint;
import slib.utils.impl.SetUtils;

public class BFS
implements GraphTraversal {
    G g;
    private WalkConstraint wc;
    URI current;
    List<URI> queue;
    Set<URI> visited;

    public BFS(G g, Set<URI> sources, WalkConstraint wc) {
        this.g = g;
        this.wc = wc;
        this.queue = new ArrayList<URI>(sources);
        this.visited = new HashSet<URI>();
    }

    public BFS(G g, URI source, WalkConstraint wc) {
        this(g, SetUtils.buildSet((Object)source), wc);
    }

    @Override
    public boolean hasNext() {
        return !this.queue.isEmpty();
    }

    @Override
    public URI next() {
        URI src = this.queue.get(0);
        this.queue.remove(0);
        Set vertices = this.g.getV(src, this.wc);
        for (URI v : vertices) {
            if (this.visited.contains(v)) continue;
            this.queue.add(v);
            this.visited.add(v);
        }
        this.current = src;
        return src;
    }
}

