/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.scopes;

import com.github.sommeri.less4j.core.ast.ReusableStructureName;
import com.github.sommeri.less4j.core.compiler.scopes.FullMixinDefinition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MixinsScope {
    private Map<String, List<FullMixinDefinition>> storage = new HashMap<String, List<FullMixinDefinition>>();

    public void registerMixin(FullMixinDefinition mixin) {
        List<ReusableStructureName> names = mixin.getMixin().getNames();
        for (ReusableStructureName name : names) {
            this.registerMixin(name, mixin);
        }
    }

    private void registerMixin(ReusableStructureName name, FullMixinDefinition mixin) {
        String nameAsString = name.asString();
        List<FullMixinDefinition> list = this.storage.get(nameAsString);
        if (list == null) {
            list = new ArrayList<FullMixinDefinition>();
            this.storage.put(nameAsString, list);
        }
        list.add(mixin);
    }

    public List<FullMixinDefinition> getMixins(ReusableStructureName name) {
        return this.storage.get(name.asString());
    }

    public boolean contains(ReusableStructureName name) {
        return this.storage.containsKey(name.asString());
    }

    public int size() {
        return this.storage.size();
    }
}

