/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.parser;

import com.github.sommeri.less4j.LessSource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.antlr.runtime.Token;
import org.antlr.runtime.tree.CommonTree;

public class HiddenTokenAwareTree
extends CommonTree {
    private final LessSource source;
    private List<Token> preceding = new LinkedList<Token>();
    private List<Token> orphans = new LinkedList<Token>();
    private List<Token> following = new LinkedList<Token>();

    public HiddenTokenAwareTree(Token payload, LessSource source) {
        super(payload);
        this.source = source;
    }

    public HiddenTokenAwareTree(LessSource source) {
        this.source = source;
    }

    public HiddenTokenAwareTree(CommonTree node, LessSource source) {
        super(node);
        this.source = source;
    }

    public LessSource getSource() {
        return this.source;
    }

    public HiddenTokenAwareTree getChild(int i) {
        return (HiddenTokenAwareTree)super.getChild(i);
    }

    public List<HiddenTokenAwareTree> getChildren() {
        List<HiddenTokenAwareTree> result = super.getChildren();
        if (result == null) {
            result = Collections.emptyList();
        }
        return result;
    }

    public HiddenTokenAwareTree getParent() {
        return (HiddenTokenAwareTree)super.getParent();
    }

    public List<Token> getPreceding() {
        return this.preceding;
    }

    public List<Token> chopPreceedingUpToLastOfType(int type) {
        ArrayList<Token> result = new ArrayList<Token>();
        List<Token> preceding = this.getPreceding();
        int index = this.lastTokenOfType(preceding, type);
        for (int i = 0; i <= index; ++i) {
            Token next = preceding.remove(0);
            result.add(next);
        }
        return result;
    }

    private int lastTokenOfType(List<Token> list, int type) {
        if (list.isEmpty()) {
            return -1;
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            Token token = list.get(i);
            if (token.getType() != type) continue;
            return i;
        }
        return -1;
    }

    public List<Token> getFollowing() {
        return this.following;
    }

    public List<Token> getOrphans() {
        return this.orphans;
    }

    public void addPreceding(Token token) {
        this.preceding.add(token);
    }

    public void addPreceding(List<Token> tokens) {
        this.preceding.addAll(tokens);
    }

    public void addBeforePreceding(List<Token> tokens) {
        this.preceding.addAll(0, tokens);
    }

    public void addOrphan(Token token) {
        this.orphans.add(token);
    }

    public void addOrphans(List<Token> tokens) {
        this.orphans.addAll(tokens);
    }

    public void addFollowing(Token token) {
        this.following.add(token);
    }

    public void addBeforeFollowing(List<Token> tokens) {
        this.following.addAll(0, tokens);
    }

    public void addFollowing(List<Token> tokens) {
        this.following.addAll(tokens);
    }

    public void pushHiddenToKids() {
        List<HiddenTokenAwareTree> children = this.getChildren();
        if (children == null || children.isEmpty()) {
            return;
        }
        HiddenTokenAwareTree first = children.get(0);
        first.addBeforePreceding(this.getPreceding());
        HiddenTokenAwareTree last = children.get(children.size() - 1);
        last.addFollowing(this.getFollowing());
    }

    public void giveHidden(HiddenTokenAwareTree previous, HiddenTokenAwareTree next) {
        if (previous != null) {
            previous.addFollowing(this.getPreceding());
        }
        if (next != null) {
            next.addBeforePreceding(this.getFollowing());
        }
    }

    public HiddenTokenAwareTree getLastChild() {
        return this.getChild(this.getChildCount() - 1);
    }

    public String toString() {
        return super.toString() + " " + this.getLine() + ":" + this.getCharPositionInLine() + 1;
    }

    public HiddenTokenAwareTree getNextSibling() {
        if (this.getParent() == null) {
            return null;
        }
        List<HiddenTokenAwareTree> siblings = this.getParent().getChildren();
        int indx = siblings.indexOf((Object)this) + 1;
        return indx >= siblings.size() ? null : siblings.get(indx);
    }

    public HiddenTokenAwareTree getPreviousSibling() {
        if (this.getParent() == null) {
            return null;
        }
        List<HiddenTokenAwareTree> siblings = this.getParent().getChildren();
        int indx = siblings.indexOf((Object)this) - 1;
        return indx < 0 ? null : siblings.get(indx);
    }

    public void pushHiddenToSiblings() {
        HiddenTokenAwareTree nextSibling;
        HiddenTokenAwareTree previousSibling = this.getPreviousSibling();
        if (previousSibling != null) {
            previousSibling.addFollowing(this.getPreceding());
        }
        if ((nextSibling = this.getNextSibling()) != null) {
            nextSibling.addBeforePreceding(this.getFollowing());
        }
    }

    public void removePreceding() {
        this.preceding = new ArrayList<Token>();
    }
}

