/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.parser;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenStream;

public class ParsersSemanticPredicates {
    private static final String KEYFRAMES = "keyframes";
    private static final String VIEWPORT = "viewport";
    private static final Set<String> PAGE_MARGIN_BOXES = new HashSet<String>(Arrays.asList("@top-left-corner", "@top-left", "@top-center", "@top-right", "@top-right-corner", "@bottom-left-corner", "@bottom-left", "@bottom-center", "@bottom-right", "@bottom-right-corner", "@left-top", "@left-middle", "@left-bottom", "@right-top", "@right-middle", "@right-bottom"));
    private static Set<String> NTH_PSEUDOCLASSES = new HashSet<String>();

    public boolean insideNth(TokenStream input) {
        return this.isNthPseudoClass(input.LT(-1));
    }

    private boolean isNthPseudoClass(Token a) {
        if (a == null) {
            return false;
        }
        String text = a.getText();
        if (text == null) {
            return false;
        }
        return NTH_PSEUDOCLASSES.contains(text.toLowerCase());
    }

    public boolean onFunctionStart(TokenStream input) {
        return this.isFunctionStart(input.LT(1), input.LT(2));
    }

    private boolean isFunctionStart(Token first, Token second) {
        if (first == null || second == null) {
            return false;
        }
        int ft = first.getType();
        int st = second.getType();
        if (ft != 61 && ft != 108 || st != 62 && st != 63 && st != 82) {
            return false;
        }
        return this.directlyFollows(first, second);
    }

    public boolean onEmptySeparator(TokenStream input) {
        return this.isEmptySeparator(input.LT(-1), input.LT(1), input.LT(2));
    }

    private boolean isEmptySeparator(Token previousT, Token firstT, Token secondT) {
        if (previousT == null) {
            return false;
        }
        if (!(previousT instanceof CommonToken && firstT instanceof CommonToken && secondT instanceof CommonToken)) {
            return false;
        }
        CommonToken previous = (CommonToken)previousT;
        CommonToken first = (CommonToken)firstT;
        CommonToken second = (CommonToken)secondT;
        if (this.isArithmeticOperator(previous)) {
            return false;
        }
        if (this.directlyFollows(previous, first)) {
            return false;
        }
        if (this.isArithmeticOperator(first) && this.isArithmeticOperator(second)) {
            return false;
        }
        return !this.isArithmeticOperator(first) || this.isArithmeticOperator(second) || this.directlyFollows(first, second);
    }

    private boolean isArithmeticOperator(CommonToken previous) {
        return previous.getType() == 72 || previous.getType() == 70 || previous.getType() == 73 || previous.getType() == 105;
    }

    public boolean directlyFollows(Token first, Token second) {
        if (!(first instanceof CommonToken) || !(second instanceof CommonToken)) {
            return false;
        }
        CommonToken firstT = (CommonToken)first;
        CommonToken secondT = (CommonToken)second;
        return this.directlyFollows(firstT, secondT);
    }

    private boolean directlyFollows(CommonToken firstT, CommonToken secondT) {
        if (firstT.getStopIndex() + 1 != secondT.getStartIndex()) {
            return false;
        }
        String text = firstT.getText();
        if (text == null || text.isEmpty()) {
            return true;
        }
        String substring = text.substring(text.length() - 1);
        return substring.equals(substring.trim());
    }

    public boolean isWhenKeyword(Token token) {
        if (token == null || !(token instanceof CommonToken) || token.getType() != 61) {
            return false;
        }
        String word = token.getText().trim().toLowerCase();
        return "when".equals(word);
    }

    public boolean onEmptyCombinator(TokenStream input) {
        return this.isEmptyCombinator(input.LT(-1), input.LT(1));
    }

    private boolean isEmptyCombinator(Token first, Token second) {
        return !this.directlyFollows(first, second);
    }

    public boolean isKeyframes(Token token) {
        return this.isVendorPrefixedAtName(token, KEYFRAMES);
    }

    public boolean isViewport(Token token) {
        return this.isVendorPrefixedAtName(token, VIEWPORT);
    }

    public boolean isPageMarginBox(Token token) {
        return this.isAmongAtNames(token, PAGE_MARGIN_BOXES);
    }

    private boolean isAmongAtNames(Token token, Set<String> atNames) {
        if (token.getType() != 60 || token.getText() == null) {
            return false;
        }
        String text = token.getText().toLowerCase();
        return atNames.contains(text);
    }

    private boolean isVendorPrefixedAtName(Token token, String atName) {
        if (token.getType() != 60 || token.getText() == null) {
            return false;
        }
        String text = token.getText().toLowerCase();
        return text.startsWith("@") && text.endsWith(atName);
    }

    static {
        NTH_PSEUDOCLASSES.add("nth-child");
        NTH_PSEUDOCLASSES.add("nth-last-child");
        NTH_PSEUDOCLASSES.add("nth-of-type");
        NTH_PSEUDOCLASSES.add("nth-last-of-type");
    }
}

