/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.utils;

import com.github.sommeri.less4j.Less4jException;
import com.github.sommeri.less4j.LessCompiler;
import com.github.sommeri.less4j.core.ThreadUnsafeLessCompiler;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;

public class ReadmeExample {
    public static void main(String[] args) throws Less4jException {
        File inputLessFile = ReadmeExample.createFile("sampleInput.less", "* { margin: 1 1 1 1; }");
        ThreadUnsafeLessCompiler compiler = new ThreadUnsafeLessCompiler();
        LessCompiler.CompilationResult compilationResult = compiler.compile(inputLessFile);
        System.out.println(compilationResult.getCss());
        for (LessCompiler.Problem warning : compilationResult.getWarnings()) {
            System.err.println(ReadmeExample.format(warning));
        }
        ReadmeExample.deleteFile(inputLessFile);
    }

    private static void deleteFile(File inputLessFile) {
        try {
            FileUtils.forceDelete((File)inputLessFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static File createFile(String filename, String content) {
        File file = new File(filename);
        try {
            FileUtils.writeStringToFile((File)file, (String)content, (boolean)false);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return file;
    }

    private static String format(LessCompiler.Problem warning) {
        return "WARNING " + warning.getLine() + ":" + warning.getCharacter() + " " + warning.getMessage();
    }
}

