/*
 * Decompiled with CFR 0.152.
 */
package org.junit.contrib.java.lang.system;

import org.junit.contrib.java.lang.system.RestoreSystemProperties;
import org.junit.rules.ExternalResource;

public class ClearSystemProperties
extends ExternalResource {
    private final RestoreSystemProperties restoreSystemProperty;
    private final String[] names;

    public ClearSystemProperties(String ... names) {
        this.names = names;
        this.restoreSystemProperty = new RestoreSystemProperties(names);
    }

    protected void before() throws Throwable {
        this.backupOriginalValue();
        this.clearProperties();
    }

    protected void after() {
        this.restoreOriginalValue();
    }

    private void backupOriginalValue() throws Throwable {
        this.restoreSystemProperty.before();
    }

    private void clearProperties() {
        for (String name : this.names) {
            System.clearProperty(name);
        }
    }

    private void restoreOriginalValue() {
        this.restoreSystemProperty.after();
    }
}

