/*
 * Decompiled with CFR 0.152.
 */
package org.junit.contrib.java.lang.system;

import org.junit.rules.ExternalResource;

public class RestoreSystemProperties
extends ExternalResource {
    private final String[] properties;
    private String[] originalValues;

    public RestoreSystemProperties(String ... properties) {
        this.properties = properties;
    }

    protected void before() throws Throwable {
        this.originalValues = new String[this.properties.length];
        for (int i = 0; i < this.properties.length; ++i) {
            this.originalValues[i] = System.getProperty(this.properties[i]);
        }
    }

    protected void after() {
        for (int i = 0; i < this.properties.length; ++i) {
            if (this.originalValues[i] == null) {
                System.clearProperty(this.properties[i]);
                continue;
            }
            System.setProperty(this.properties[i], this.originalValues[i]);
        }
    }
}

