/*
 * Decompiled with CFR 0.152.
 */
package org.testng.junit5;

import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.AbstractTestDescriptor;
import org.junit.platform.engine.support.descriptor.ClassSource;

public class ClassDescriptor
extends AbstractTestDescriptor {
    private final Class<?> testClass;

    static boolean isCandidate(Class<?> candidate) {
        if (!ReflectionUtils.isPublic(candidate)) {
            return false;
        }
        if (ReflectionUtils.isAbstract(candidate)) {
            return false;
        }
        return !ReflectionUtils.isInnerClass(candidate);
    }

    static ClassDescriptor newContainerDescriptor(UniqueId container, Class<?> testClass) {
        UniqueId id = container.append("testng-class", testClass.getTypeName());
        return new ClassDescriptor(id, testClass);
    }

    private ClassDescriptor(UniqueId uniqueId, Class<?> testClass) {
        super(uniqueId, testClass.getSimpleName(), (TestSource)ClassSource.from(testClass));
        this.testClass = testClass;
    }

    public TestDescriptor.Type getType() {
        return TestDescriptor.Type.CONTAINER;
    }

    public Class<?> getTestClass() {
        return this.testClass;
    }
}

