/*
 * Decompiled with CFR 0.152.
 */
package org.testng.junit5;

import java.net.URI;
import java.util.Collection;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import org.junit.platform.commons.util.ClassFilter;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.engine.EngineDiscoveryRequest;
import org.junit.platform.engine.discovery.ClassSelector;
import org.junit.platform.engine.discovery.ClasspathRootSelector;
import org.junit.platform.engine.discovery.PackageSelector;
import org.junit.platform.engine.support.descriptor.EngineDescriptor;

class DiscoveryHelper {
    private final EngineDiscoveryRequest engineDiscoveryRequest;
    private final ClassFilter classFilter;

    DiscoveryHelper(EngineDiscoveryRequest engineDiscoveryRequest, ClassFilter classFilter) {
        this.engineDiscoveryRequest = engineDiscoveryRequest;
        this.classFilter = classFilter;
    }

    void discover(EngineDescriptor engine, BiConsumer<EngineDescriptor, Class<?>> handler) {
        this.engineDiscoveryRequest.getSelectorsByType(ClasspathRootSelector.class).stream().map(ClasspathRootSelector::getClasspathRoot).map(uri -> ReflectionUtils.findAllClassesInClasspathRoot((URI)uri, (ClassFilter)this.classFilter)).flatMap(Collection::stream).forEach(candidate -> handler.accept(engine, (Class<?>)candidate));
        this.engineDiscoveryRequest.getSelectorsByType(PackageSelector.class).stream().map(PackageSelector::getPackageName).map(packageName -> ReflectionUtils.findAllClassesInPackage((String)packageName, (ClassFilter)this.classFilter)).flatMap(Collection::stream).forEach(candidate -> handler.accept(engine, (Class<?>)candidate));
        this.engineDiscoveryRequest.getSelectorsByType(ClassSelector.class).stream().map(ClassSelector::getJavaClass).filter((Predicate<Class>)this.classFilter).forEach(candidate -> handler.accept(engine, (Class<?>)candidate));
    }
}

