/*
 * Decompiled with CFR 0.152.
 */
package org.testng.junit5;

import java.lang.reflect.Method;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.UniqueId;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.ITestResult;
import org.testng.junit5.MethodDescriptor;

class TestListener
implements ITestListener {
    private final EngineExecutionListener platform;
    private final UniqueId classDescriptorId;

    TestListener(EngineExecutionListener platform, UniqueId classDescriptorId) {
        this.platform = platform;
        this.classDescriptorId = classDescriptorId;
    }

    private TestDescriptor convert(ITestResult result) {
        Method method = result.getMethod().getConstructorOrMethod().getMethod();
        return MethodDescriptor.newMethodDescriptor(this.classDescriptorId, method);
    }

    public void onTestStart(ITestResult result) {
        this.platform.executionStarted(this.convert(result));
    }

    public void onTestSuccess(ITestResult result) {
        this.platform.executionFinished(this.convert(result), TestExecutionResult.successful());
    }

    public void onTestFailure(ITestResult result) {
        this.platform.executionFinished(this.convert(result), TestExecutionResult.failed((Throwable)result.getThrowable()));
    }

    public void onTestSkipped(ITestResult result) {
        this.platform.executionSkipped(this.convert(result), "because");
    }

    public void onTestFailedButWithinSuccessPercentage(ITestResult result) {
        this.platform.executionFinished(this.convert(result), TestExecutionResult.successful());
    }

    public void onStart(ITestContext context) {
    }

    public void onFinish(ITestContext context) {
    }
}

