/*
 * Decompiled with CFR 0.152.
 */
package com.github.timurstrekalov.saga.maven;

import com.github.timurstrekalov.saga.core.Config;
import com.github.timurstrekalov.saga.core.CoverageGenerator;
import com.github.timurstrekalov.saga.core.CoverageGeneratorFactory;
import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="coverage", defaultPhase=LifecyclePhase.VERIFY, threadSafe=true)
public class SagaMojo
extends AbstractMojo {
    @Parameter(required=true)
    private String baseDir;
    @Parameter
    private String includes;
    @Parameter
    private String excludes;
    @Parameter(required=true)
    private File outputDir;
    @Parameter(defaultValue="false")
    private Boolean outputInstrumentedFiles;
    @Parameter
    private String[] noInstrumentPatterns;
    @Parameter(defaultValue="true")
    private Boolean cacheInstrumentedCode;
    @Parameter(defaultValue="TOTAL")
    private String outputStrategy;
    @Parameter
    private Integer threadCount;
    @Parameter(defaultValue="false")
    private Boolean includeInlineScripts;
    @Parameter(defaultValue="300000")
    private Long backgroundJavaScriptTimeout;
    @Parameter
    private String sourcesToPreload;
    @Parameter(defaultValue="UTF-8")
    private String sourcesToPreloadEncoding;
    @Parameter(defaultValue="FIREFOX_3_6")
    private String browserVersion;
    @Parameter(defaultValue="HTML, RAW")
    private String reportFormats;
    @Parameter(defaultValue="coverage")
    private String sortBy;
    @Parameter(defaultValue="ascending")
    private String order;

    public void execute() throws MojoExecutionException {
        try {
            CoverageGenerator gen = CoverageGeneratorFactory.newInstance((String)this.baseDir, (File)this.outputDir);
            Config config = gen.getConfig();
            config.setIncludes(this.includes);
            config.setExcludes(this.excludes);
            config.setOutputInstrumentedFiles(this.outputInstrumentedFiles);
            config.setCacheInstrumentedCode(this.cacheInstrumentedCode);
            config.setNoInstrumentPatterns(this.noInstrumentPatterns);
            config.setOutputStrategy(this.outputStrategy);
            config.setThreadCount(this.threadCount);
            config.setIncludeInlineScripts(this.includeInlineScripts);
            config.setBackgroundJavaScriptTimeout(this.backgroundJavaScriptTimeout);
            config.setSourcesToPreload(this.sourcesToPreload);
            config.setSourcesToPreloadEncoding(this.sourcesToPreloadEncoding);
            config.setBrowserVersion(this.browserVersion);
            config.setReportFormats(this.reportFormats);
            config.setSortBy(this.sortBy);
            config.setOrder(this.order);
            gen.instrumentAndGenerateReports();
        }
        catch (IllegalArgumentException e) {
            throw new MojoExecutionException("Caught IllegalArgumentException: illegal parameters?", (Exception)e);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error generating coverage", e);
        }
    }
}

