/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.servlet;

import com.github.tomakehurst.wiremock.common.Encoding;
import com.github.tomakehurst.wiremock.common.Gzip;
import com.github.tomakehurst.wiremock.common.Strings;
import com.github.tomakehurst.wiremock.common.Urls;
import com.github.tomakehurst.wiremock.http.ContentTypeHeader;
import com.github.tomakehurst.wiremock.http.Cookie;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.QueryParameter;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.http.multipart.PartParser;
import com.github.tomakehurst.wiremock.jetty9.JettyUtils;
import com.github.tomakehurst.wiremock.servlet.MultipartRequestConfigurer;
import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.server.Request;

public class WireMockHttpServletRequestAdapter
implements com.github.tomakehurst.wiremock.http.Request {
    public static final String ORIGINAL_REQUEST_KEY = "wiremock.ORIGINAL_REQUEST";
    private final HttpServletRequest request;
    private final MultipartRequestConfigurer multipartRequestConfigurer;
    private byte[] cachedBody;
    private String urlPrefixToRemove;
    private Collection<Request.Part> cachedMultiparts;

    public WireMockHttpServletRequestAdapter(HttpServletRequest request, MultipartRequestConfigurer multipartRequestConfigurer, String urlPrefixToRemove) {
        this.request = request;
        this.multipartRequestConfigurer = multipartRequestConfigurer;
        this.urlPrefixToRemove = urlPrefixToRemove;
    }

    @Override
    public String getUrl() {
        String url = this.request.getRequestURI();
        String contextPath = this.request.getContextPath();
        if (!com.google.common.base.Strings.isNullOrEmpty((String)contextPath) && url.startsWith(contextPath)) {
            url = url.substring(contextPath.length());
        }
        if (!com.google.common.base.Strings.isNullOrEmpty((String)this.urlPrefixToRemove) && url.startsWith(this.urlPrefixToRemove)) {
            url = url.substring(this.urlPrefixToRemove.length());
        }
        return this.withQueryStringIfPresent(url);
    }

    @Override
    public String getAbsoluteUrl() {
        return this.withQueryStringIfPresent(this.request.getRequestURL().toString());
    }

    private String withQueryStringIfPresent(String url) {
        return url + (com.google.common.base.Strings.isNullOrEmpty((String)this.request.getQueryString()) ? "" : "?" + this.request.getQueryString());
    }

    @Override
    public RequestMethod getMethod() {
        return RequestMethod.fromString(this.request.getMethod().toUpperCase());
    }

    @Override
    public String getScheme() {
        return this.request.getScheme();
    }

    @Override
    public String getHost() {
        return this.request.getServerName();
    }

    @Override
    public int getPort() {
        return this.request.getServerPort();
    }

    @Override
    public String getClientIp() {
        String forwardedForHeader = this.getHeader("X-Forwarded-For");
        if (forwardedForHeader != null && forwardedForHeader.length() > 0) {
            return forwardedForHeader;
        }
        return this.request.getRemoteAddr();
    }

    @Override
    public byte[] getBody() {
        if (this.cachedBody == null) {
            try {
                byte[] body = ByteStreams.toByteArray((InputStream)this.request.getInputStream());
                boolean isGzipped = this.hasGzipEncoding() || Gzip.isGzipped(body);
                this.cachedBody = isGzipped ? Gzip.unGzip(body) : body;
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
        return this.cachedBody;
    }

    private Charset encodingFromContentTypeHeaderOrUtf8() {
        ContentTypeHeader contentTypeHeader = this.contentTypeHeader();
        if (contentTypeHeader != null) {
            return contentTypeHeader.charset();
        }
        return Charsets.UTF_8;
    }

    private boolean hasGzipEncoding() {
        String encodingHeader = this.request.getHeader("Content-Encoding");
        return encodingHeader != null && encodingHeader.contains("gzip");
    }

    @Override
    public String getBodyAsString() {
        return Strings.stringFromBytes(this.getBody(), this.encodingFromContentTypeHeaderOrUtf8());
    }

    @Override
    public String getBodyAsBase64() {
        return Encoding.encodeBase64(this.getBody());
    }

    @Override
    public String getHeader(String key) {
        ArrayList<String> headerNames = Collections.list(this.request.getHeaderNames());
        for (String currentKey : headerNames) {
            if (!currentKey.equalsIgnoreCase(key)) continue;
            return this.request.getHeader(currentKey);
        }
        return null;
    }

    @Override
    public HttpHeader header(String key) {
        ArrayList<String> headerNames = Collections.list(this.request.getHeaderNames());
        for (String currentKey : headerNames) {
            if (!currentKey.equalsIgnoreCase(key)) continue;
            ArrayList<String> valueList = Collections.list(this.request.getHeaders(currentKey));
            if (valueList.isEmpty()) {
                return HttpHeader.empty(key);
            }
            return new HttpHeader(key, (Collection<String>)valueList);
        }
        return HttpHeader.absent(key);
    }

    @Override
    public ContentTypeHeader contentTypeHeader() {
        return this.getHeaders().getContentTypeHeader();
    }

    @Override
    public boolean containsHeader(String key) {
        return this.header(key).isPresent();
    }

    @Override
    public HttpHeaders getHeaders() {
        ArrayList headerList = Lists.newArrayList();
        for (String key : this.getAllHeaderKeys()) {
            headerList.add(this.header(key));
        }
        return new HttpHeaders(headerList);
    }

    @Override
    public Set<String> getAllHeaderKeys() {
        LinkedHashSet<String> headerKeys = new LinkedHashSet<String>();
        Enumeration headerNames = this.request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            headerKeys.add((String)headerNames.nextElement());
        }
        return headerKeys;
    }

    @Override
    public Map<String, Cookie> getCookies() {
        javax.servlet.http.Cookie[] cookies;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        for (javax.servlet.http.Cookie cookie : cookies = (javax.servlet.http.Cookie[])MoreObjects.firstNonNull((Object)this.request.getCookies(), (Object)new javax.servlet.http.Cookie[0])) {
            builder.put((Object)cookie.getName(), (Object)cookie.getValue());
        }
        return Maps.transformValues((Map)builder.build().asMap(), (Function)new Function<Collection<String>, Cookie>(){

            public Cookie apply(Collection<String> input) {
                return new Cookie(null, (List<String>)ImmutableList.copyOf(input));
            }
        });
    }

    @Override
    public QueryParameter queryParameter(String key) {
        return (QueryParameter)MoreObjects.firstNonNull((Object)Urls.splitQuery(this.request.getQueryString()).get(key), (Object)QueryParameter.absent(key));
    }

    @Override
    public boolean isBrowserProxyRequest() {
        if (!JettyUtils.isJetty()) {
            return false;
        }
        if (this.request instanceof Request) {
            Request jettyRequest = (Request)this.request;
            return JettyUtils.getUri(jettyRequest).isAbsolute();
        }
        return false;
    }

    @Override
    public Collection<Request.Part> getParts() {
        if (!this.isMultipart()) {
            return null;
        }
        if (this.cachedMultiparts == null) {
            this.cachedMultiparts = PartParser.parseFrom(this);
        }
        return this.cachedMultiparts.size() > 0 ? this.cachedMultiparts : null;
    }

    @Override
    public boolean isMultipart() {
        String header = this.getHeader("Content-Type");
        return header != null && header.contains("multipart/form-data");
    }

    @Override
    public Request.Part getPart(final String name) {
        if (name == null || name.length() == 0) {
            return null;
        }
        if (this.cachedMultiparts == null && this.getParts() == null) {
            return null;
        }
        return (Request.Part)FluentIterable.from(this.cachedMultiparts).firstMatch((Predicate)new Predicate<Request.Part>(){

            public boolean apply(Request.Part input) {
                return name.equals(input.getName());
            }
        }).get();
    }

    @Override
    public Optional<com.github.tomakehurst.wiremock.http.Request> getOriginalRequest() {
        com.github.tomakehurst.wiremock.http.Request originalRequest = (com.github.tomakehurst.wiremock.http.Request)this.request.getAttribute(ORIGINAL_REQUEST_KEY);
        return Optional.fromNullable((Object)originalRequest);
    }

    public String toString() {
        return this.request.toString() + this.getBodyAsString();
    }
}

