/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.github.jknack.handlebars.internal;

import java.io.IOException;
import java.io.Writer;
import java.util.LinkedList;
import java.util.Map;
import wiremock.com.github.jknack.handlebars.Context;
import wiremock.com.github.jknack.handlebars.Handlebars;
import wiremock.com.github.jknack.handlebars.Template;
import wiremock.com.github.jknack.handlebars.internal.BaseTemplate;

public class PartialBlockForwardingTemplate
extends BaseTemplate {
    private final Template block;
    private final Template parentPartialBlock;
    private final Template callee;

    public PartialBlockForwardingTemplate(Template parent, Template block, Template parentPartialBlock, Template callee, Handlebars handlebars) {
        super(handlebars);
        this.block = block;
        this.parentPartialBlock = parentPartialBlock;
        this.callee = callee;
        this.filename(block.filename());
        this.position(parent.position()[0], parent.position()[1]);
    }

    @Override
    protected void merge(Context context, Writer writer) throws IOException {
        LinkedList partials = (LinkedList)context.data("__inline_partials_");
        Map inlineTemplates = (Map)partials.getLast();
        Template oldPartialBlock = (Template)inlineTemplates.get("@partial-block");
        Template oldCallee = (Template)context.data(Context.CALLEE);
        context.data(Context.CALLEE, this.callee);
        inlineTemplates.put("@partial-block", this.parentPartialBlock);
        this.block.apply(context, writer);
        inlineTemplates.put("@partial-block", oldPartialBlock);
        context.data(Context.CALLEE, oldCallee);
    }

    @Override
    public String text() {
        return this.block.text();
    }
}

