/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.client;

import com.github.tomakehurst.wiremock.client.VerificationException;
import com.github.tomakehurst.wiremock.common.HttpClientUtils;
import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.core.Admin;
import com.github.tomakehurst.wiremock.global.GlobalSettings;
import com.github.tomakehurst.wiremock.global.RequestDelaySpec;
import com.github.tomakehurst.wiremock.http.HttpClientFactory;
import com.github.tomakehurst.wiremock.http.MimeType;
import com.github.tomakehurst.wiremock.matching.RequestPattern;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import com.github.tomakehurst.wiremock.verification.FindRequestsResult;
import com.github.tomakehurst.wiremock.verification.VerificationResult;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;

public class HttpAdminClient
implements Admin {
    private static final String ADMIN_URL_PREFIX = "http://%s:%d%s/__admin";
    private static final String LOCAL_WIREMOCK_NEW_RESPONSE_URL = "http://%s:%d%s/__admin/mappings/new";
    private static final String LOCAL_WIREMOCK_RESET_URL = "http://%s:%d%s/__admin/reset";
    private static final String LOCAL_WIREMOCK_RESET_SCENARIOS_URL = "http://%s:%d%s/__admin/scenarios/reset";
    private static final String LOCAL_WIREMOCK_COUNT_REQUESTS_URL = "http://%s:%d%s/__admin/requests/count";
    private static final String LOCAL_WIREMOCK_FIND_REQUESTS_URL = "http://%s:%d%s/__admin/requests/find";
    private static final String WIREMOCK_GLOBAL_SETTINGS_URL = "http://%s:%d%s/__admin/settings";
    private static final String SOCKET_ACCEPT_DELAY_URL = "http://%s:%d%s/__admin/socket-delay";
    private final String host;
    private final int port;
    private final String urlPathPrefix;
    private final HttpClient httpClient;

    public HttpAdminClient(String host, int port, String urlPathPrefix) {
        this.host = host;
        this.port = port;
        this.urlPathPrefix = urlPathPrefix;
        this.httpClient = HttpClientFactory.createClient();
    }

    public HttpAdminClient(String host, int port) {
        this(host, port, "");
    }

    @Override
    public void addStubMapping(StubMapping stubMapping) {
        String json = Json.write(stubMapping);
        int status = this.postJsonAndReturnStatus(this.newMappingUrl(), json);
        if (status != 201) {
            throw new RuntimeException("Returned status code was " + status);
        }
    }

    @Override
    public void resetMappings() {
        int status = this.postEmptyBodyAndReturnStatus(this.resetUrl());
        this.assertStatusOk(status);
    }

    @Override
    public void resetScenarios() {
        int status = this.postEmptyBodyAndReturnStatus(this.resetScenariosUrl());
        this.assertStatusOk(status);
    }

    private void assertStatusOk(int status) {
        if (status != 200) {
            throw new RuntimeException("Returned status code was " + status);
        }
    }

    @Override
    public int countRequestsMatching(RequestPattern requestPattern) {
        String json = Json.write(requestPattern);
        String body = this.postJsonAssertOkAndReturnBody(this.requestsCountUrl(), json, 200);
        VerificationResult verificationResult = VerificationResult.buildVerificationResultFrom(body);
        return verificationResult.getCount();
    }

    @Override
    public FindRequestsResult findRequestsMatching(RequestPattern requestPattern) {
        String json = Json.write(requestPattern);
        String body = this.postJsonAssertOkAndReturnBody(this.findRequestsUrl(), json, 200);
        return Json.read(body, FindRequestsResult.class);
    }

    @Override
    public void updateGlobalSettings(GlobalSettings settings) {
        String json = Json.write(settings);
        this.postJsonAssertOkAndReturnBody(this.globalSettingsUrl(), json, 200);
    }

    @Override
    public void addSocketAcceptDelay(RequestDelaySpec spec) {
        String json = Json.write(spec);
        this.postJsonAssertOkAndReturnBody(this.socketAcceptDelayUrl(), json, 200);
    }

    private int postJsonAndReturnStatus(String url, String json) {
        HttpPost post = new HttpPost(url);
        try {
            if (json != null) {
                post.setEntity((HttpEntity)new StringEntity(json, MimeType.JSON.toString(), "utf-8"));
            }
            HttpResponse response = this.httpClient.execute((HttpUriRequest)post);
            int statusCode = response.getStatusLine().getStatusCode();
            HttpClientUtils.getEntityAsStringAndCloseStream(response);
            return statusCode;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String postJsonAssertOkAndReturnBody(String url, String json, int expectedStatus) {
        HttpPost post = new HttpPost(url);
        try {
            HttpResponse response;
            int statusCode;
            if (json != null) {
                post.setEntity((HttpEntity)new StringEntity(json, MimeType.JSON.toString(), "utf-8"));
            }
            if ((statusCode = (response = this.httpClient.execute((HttpUriRequest)post)).getStatusLine().getStatusCode()) != expectedStatus) {
                throw new VerificationException("Expected status " + expectedStatus + " for " + url + " but was " + statusCode);
            }
            String body = HttpClientUtils.getEntityAsStringAndCloseStream(response);
            return body;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private int postEmptyBodyAndReturnStatus(String url) {
        return this.postJsonAndReturnStatus(url, null);
    }

    private String newMappingUrl() {
        return String.format(LOCAL_WIREMOCK_NEW_RESPONSE_URL, this.host, this.port, this.urlPathPrefix);
    }

    private String resetUrl() {
        return String.format(LOCAL_WIREMOCK_RESET_URL, this.host, this.port, this.urlPathPrefix);
    }

    private String resetScenariosUrl() {
        return String.format(LOCAL_WIREMOCK_RESET_SCENARIOS_URL, this.host, this.port, this.urlPathPrefix);
    }

    private String requestsCountUrl() {
        return String.format(LOCAL_WIREMOCK_COUNT_REQUESTS_URL, this.host, this.port, this.urlPathPrefix);
    }

    private String findRequestsUrl() {
        return String.format(LOCAL_WIREMOCK_FIND_REQUESTS_URL, this.host, this.port, this.urlPathPrefix);
    }

    private String globalSettingsUrl() {
        return String.format(WIREMOCK_GLOBAL_SETTINGS_URL, this.host, this.port, this.urlPathPrefix);
    }

    private String socketAcceptDelayUrl() {
        return String.format(SOCKET_ACCEPT_DELAY_URL, this.host, this.port, this.urlPathPrefix);
    }
}

