/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http;

import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.google.common.base.Optional;

public class ContentTypeHeader
extends HttpHeader {
    public static final String KEY = "Content-Type";
    private String[] parts;

    public ContentTypeHeader(String stringValue) {
        super(KEY, stringValue);
        this.parts = stringValue != null ? stringValue.split(";") : new String[]{};
    }

    private ContentTypeHeader() {
        super(KEY, new String[0]);
    }

    public static ContentTypeHeader absent() {
        return new ContentTypeHeader();
    }

    public String mimeTypePart() {
        return this.parts[0];
    }

    public Optional<String> encodingPart() {
        if (this.parts.length < 2) {
            return Optional.absent();
        }
        return Optional.of((Object)this.parts[1].split("=")[1]);
    }
}

