/*
 * Decompiled with CFR 0.152.
 */
package com.github.veithen.alta;

import com.github.veithen.alta.ArtifactId;
import java.util.Collection;
import java.util.HashSet;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;

class IncludeExcludeArtifactFilter
implements ArtifactFilter {
    private Collection<ArtifactId> includes;
    private Collection<ArtifactId> excludes;

    public IncludeExcludeArtifactFilter(Collection<String> includes, Collection<String> excludes, String groupPrefix) {
        this.includes = IncludeExcludeArtifactFilter.toIds(includes);
        this.excludes = IncludeExcludeArtifactFilter.toIds(excludes);
        if (groupPrefix != null && groupPrefix.length() > 0) {
            this.includes.add(new ArtifactId(groupPrefix + "*", "*", "*", "*"));
        }
    }

    private static Collection<ArtifactId> toIds(Collection<String> patterns) {
        HashSet<ArtifactId> result = new HashSet<ArtifactId>();
        if (patterns != null) {
            for (String pattern : patterns) {
                result.add(new ArtifactId(pattern));
            }
        }
        return result;
    }

    public boolean isSelected(Artifact artifact) {
        return artifact != null && this.isSelected(new ArtifactId(artifact));
    }

    boolean isSelected(ArtifactId id) {
        return (this.includes.isEmpty() || this.matches(this.includes, id)) && !this.matches(this.excludes, id);
    }

    private boolean matches(Collection<ArtifactId> patterns, ArtifactId id) {
        for (ArtifactId pattern : patterns) {
            if (!id.matches(pattern)) continue;
            return true;
        }
        return false;
    }

    public boolean include(Artifact artifact) {
        return this.isSelected(artifact);
    }
}

