/*
 * Decompiled with CFR 0.152.
 */
package com.github.veithen.alta.template;

import com.github.veithen.alta.template.InvalidTemplateException;
import com.github.veithen.alta.template.Property;
import com.github.veithen.alta.template.PropertyExpression;
import com.github.veithen.alta.template.PropertyGroup;
import com.github.veithen.alta.template.Scanner;
import com.github.veithen.alta.template.Template;
import com.github.veithen.alta.template.Text;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public final class TemplateCompiler<C> {
    private Map<String, PropertyGroup<C, ?>> propertyGroups = new HashMap();
    private PropertyGroup<C, ?> defaultPropertyGroup;

    public void addPropertyGroup(String name, PropertyGroup<C, ?> group) {
        this.propertyGroups.put(name, group);
    }

    public void setDefaultPropertyGroup(PropertyGroup<C, ?> group) {
        this.defaultPropertyGroup = group;
    }

    public Template<C> compile(String s) throws InvalidTemplateException {
        ArrayList expressions = new ArrayList();
        Scanner scanner = new Scanner(s);
        while (scanner.peek() != -1) {
            if (scanner.consume('%')) {
                String propertyName;
                PropertyGroup<C, ?> group;
                String atom = scanner.parseAtom();
                if (scanner.consume('.')) {
                    group = this.propertyGroups.get(atom);
                    if (group == null) {
                        throw new InvalidTemplateException("Unknown property group '" + atom + "'");
                    }
                    propertyName = scanner.parseAtom();
                } else {
                    group = this.defaultPropertyGroup;
                    propertyName = atom;
                }
                String prefix = "";
                String suffix = "";
                String defaultValue = null;
                if (scanner.consume('?')) {
                    prefix = scanner.parseString("?@:%");
                    scanner.expect('@');
                    suffix = scanner.parseString("?@:%");
                    if (scanner.consume(':')) {
                        defaultValue = scanner.parseString("?@:%");
                    }
                }
                scanner.expect('%');
                PropertyExpression<C, ?> expression = this.createPropertyExpression(group, propertyName, prefix, suffix, defaultValue);
                if (expression == null) {
                    throw new InvalidTemplateException("Unknown property '" + propertyName + "'");
                }
                expressions.add(expression);
                continue;
            }
            expressions.add(new Text(scanner.parseString("%")));
        }
        return new Template(expressions);
    }

    private <CG> PropertyExpression<C, CG> createPropertyExpression(PropertyGroup<C, CG> group, String propertyName, String prefix, String suffix, String defaultValue) {
        Property<CG> property = group.getProperty(propertyName);
        return property == null ? null : new PropertyExpression<C, CG>(group, property, prefix, suffix, defaultValue);
    }
}

