/*
 * Decompiled with CFR 0.152.
 */
package com.github.vincentrussell.json.datagenerator.functions;

import com.github.vincentrussell.json.datagenerator.functions.Function;
import com.github.vincentrussell.json.datagenerator.functions.FunctionInvocation;
import com.github.vincentrussell.json.datagenerator.functions.impl.AddDays;
import com.github.vincentrussell.json.datagenerator.functions.impl.AddHours;
import com.github.vincentrussell.json.datagenerator.functions.impl.AddMinutes;
import com.github.vincentrussell.json.datagenerator.functions.impl.AddMonths;
import com.github.vincentrussell.json.datagenerator.functions.impl.AddSeconds;
import com.github.vincentrussell.json.datagenerator.functions.impl.AddWeeks;
import com.github.vincentrussell.json.datagenerator.functions.impl.AddYears;
import com.github.vincentrussell.json.datagenerator.functions.impl.Alpha;
import com.github.vincentrussell.json.datagenerator.functions.impl.AlphaNumeric;
import com.github.vincentrussell.json.datagenerator.functions.impl.Bool;
import com.github.vincentrussell.json.datagenerator.functions.impl.City;
import com.github.vincentrussell.json.datagenerator.functions.impl.Company;
import com.github.vincentrussell.json.datagenerator.functions.impl.Concat;
import com.github.vincentrussell.json.datagenerator.functions.impl.CountriesList;
import com.github.vincentrussell.json.datagenerator.functions.impl.Country;
import com.github.vincentrussell.json.datagenerator.functions.impl.Date;
import com.github.vincentrussell.json.datagenerator.functions.impl.DateFormat;
import com.github.vincentrussell.json.datagenerator.functions.impl.Email;
import com.github.vincentrussell.json.datagenerator.functions.impl.FirstName;
import com.github.vincentrussell.json.datagenerator.functions.impl.Gender;
import com.github.vincentrussell.json.datagenerator.functions.impl.Get;
import com.github.vincentrussell.json.datagenerator.functions.impl.Hex;
import com.github.vincentrussell.json.datagenerator.functions.impl.Index;
import com.github.vincentrussell.json.datagenerator.functions.impl.Ipv4;
import com.github.vincentrussell.json.datagenerator.functions.impl.Ipv6;
import com.github.vincentrussell.json.datagenerator.functions.impl.LastName;
import com.github.vincentrussell.json.datagenerator.functions.impl.LoremIpsum;
import com.github.vincentrussell.json.datagenerator.functions.impl.ObjectId;
import com.github.vincentrussell.json.datagenerator.functions.impl.Phone;
import com.github.vincentrussell.json.datagenerator.functions.impl.Put;
import com.github.vincentrussell.json.datagenerator.functions.impl.Random;
import com.github.vincentrussell.json.datagenerator.functions.impl.RandomDouble;
import com.github.vincentrussell.json.datagenerator.functions.impl.RandomFloat;
import com.github.vincentrussell.json.datagenerator.functions.impl.RandomInteger;
import com.github.vincentrussell.json.datagenerator.functions.impl.RandomLong;
import com.github.vincentrussell.json.datagenerator.functions.impl.ResetIndex;
import com.github.vincentrussell.json.datagenerator.functions.impl.Ssn;
import com.github.vincentrussell.json.datagenerator.functions.impl.State;
import com.github.vincentrussell.json.datagenerator.functions.impl.Street;
import com.github.vincentrussell.json.datagenerator.functions.impl.Substring;
import com.github.vincentrussell.json.datagenerator.functions.impl.Timestamp;
import com.github.vincentrussell.json.datagenerator.functions.impl.ToLower;
import com.github.vincentrussell.json.datagenerator.functions.impl.ToUpper;
import com.github.vincentrussell.json.datagenerator.functions.impl.UUID;
import com.github.vincentrussell.json.datagenerator.functions.impl.Username;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public final class FunctionRegistry {
    private static FunctionRegistry INSTANCE;
    private final Map<FunctionInvocationHolder, MethodAndObjectHolder> functionInvocationHolderMethodConcurrentHashMap = new ConcurrentHashMap<FunctionInvocationHolder, MethodAndObjectHolder>();
    private final Map<Method, Object> methodInstanceMap = new ConcurrentHashMap<Method, Object>();
    private final Set<String> nonOverridableFunctionNames = new HashSet<String>();

    private FunctionRegistry() {
        this.registerClass(RandomInteger.class);
        this.registerClass(RandomDouble.class);
        this.registerClass(RandomFloat.class);
        this.registerClass(RandomLong.class);
        this.registerClass(Random.class);
        this.registerClass(UUID.class);
        this.registerClass(Bool.class);
        this.registerClass(Index.class);
        this.registerClass(ResetIndex.class);
        this.registerClass(LoremIpsum.class);
        this.registerClass(Concat.class);
        this.registerClass(ToUpper.class);
        this.registerClass(ToLower.class);
        this.registerClass(Substring.class);
        this.registerClass(Phone.class);
        this.registerClass(Gender.class);
        this.registerClass(Date.class);
        this.registerClass(DateFormat.class);
        this.registerClass(AddDays.class);
        this.registerClass(AddHours.class);
        this.registerClass(AddMinutes.class);
        this.registerClass(AddMonths.class);
        this.registerClass(AddSeconds.class);
        this.registerClass(AddWeeks.class);
        this.registerClass(AddYears.class);
        this.registerClass(Timestamp.class);
        this.registerClass(Alpha.class);
        this.registerClass(AlphaNumeric.class);
        this.registerClass(City.class);
        this.registerClass(Company.class);
        this.registerClass(Country.class);
        this.registerClass(Email.class);
        this.registerClass(FirstName.class);
        this.registerClass(LastName.class);
        this.registerClass(Username.class);
        this.registerClass(State.class);
        this.registerClass(Street.class);
        this.registerClass(Ssn.class);
        this.registerClass(Ipv4.class);
        this.registerClass(Ipv6.class);
        this.registerClass(ObjectId.class);
        this.registerClass(Hex.class);
        this.registerClass(CountriesList.class);
        this.registerClass(Put.class);
        this.registerClass(Get.class);
    }

    public static FunctionRegistry getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new FunctionRegistry();
        }
        return INSTANCE;
    }

    public void registerClass(Class<?> clazz) {
        Function annotation = clazz.getAnnotation(Function.class);
        this.checkClassValidity(clazz, annotation);
        try {
            for (String annotationName : annotation.name()) {
                Object instance = clazz.newInstance();
                for (Method method : clazz.getDeclaredMethods()) {
                    if (!method.isAnnotationPresent(FunctionInvocation.class)) continue;
                    this.checkMethodValidity(method);
                    MethodAndObjectHolder methodAndObjectHolder = new MethodAndObjectHolder(method, instance);
                    this.functionInvocationHolderMethodConcurrentHashMap.put(new FunctionInvocationHolder(annotationName, method.getParameterTypes()), methodAndObjectHolder);
                    this.methodInstanceMap.put(method, instance);
                }
                if (annotation.overridable()) continue;
                this.nonOverridableFunctionNames.add(annotationName);
            }
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private void checkMethodValidity(Method method) {
        int stringClassesCount = Iterables.size((Iterable)Iterables.filter(Arrays.asList(method.getParameterTypes()), (Predicate)new Predicate<Class<?>>(){

            public boolean apply(Class<?> aClass) {
                return aClass == String.class;
            }
        }));
        int stringArrayClassesCount = Iterables.size((Iterable)Iterables.filter(Arrays.asList(method.getParameterTypes()), (Predicate)new Predicate<Class<?>>(){

            public boolean apply(Class<?> aClass) {
                return aClass == String[].class;
            }
        }));
        if (!String.class.isAssignableFrom(method.getReturnType())) {
            throw new IllegalArgumentException("method " + method.getName() + " on class " + method.getDeclaringClass().getName() + " must return type String");
        }
        if (stringClassesCount != method.getParameterTypes().length && method.getParameterTypes().length > 1 || stringArrayClassesCount != 1 && stringClassesCount == 0 && method.getParameterTypes().length == 1) {
            throw new IllegalArgumentException("for method " + method.getName() + " on class " + method.getDeclaringClass().getName() + ": all method parameters need to be a String or a single String var-arg parameter");
        }
    }

    private void checkClassValidity(Class<?> clazz, Function annotation) {
        if (annotation == null) {
            throw new IllegalArgumentException(clazz.getName() + " must be annotated with " + Function.class.getName());
        }
        for (String annotationName : annotation.name()) {
            if (StringUtils.isEmpty((String)annotationName)) {
                throw new IllegalArgumentException(Function.class.getName() + "annotation on class" + clazz.getName() + " annotation must have name attribute populated");
            }
            if (!this.nonOverridableFunctionNames.contains(annotationName)) continue;
            throw new IllegalArgumentException(clazz.getName() + " can not override existing function with the same annotation: " + annotationName + " because it does not allow overriding.");
        }
        int zeroArgConstructorCount = Iterables.size((Iterable)Iterables.filter(Arrays.asList(clazz.getConstructors()), (Predicate)new Predicate<Constructor<?>>(){

            public boolean apply(Constructor<?> constructor) {
                return constructor.getParameterTypes().length == 0;
            }
        }));
        if (zeroArgConstructorCount != 1) {
            throw new IllegalArgumentException(clazz.getName() + " must have a no-arg constructor");
        }
        int validMethodCount = Iterables.size((Iterable)Iterables.filter(Arrays.asList(clazz.getDeclaredMethods()), (Predicate)new Predicate<Method>(){

            public boolean apply(Method method) {
                return method.isAnnotationPresent(FunctionInvocation.class);
            }
        }));
        if (validMethodCount == 0) {
            throw new IllegalArgumentException(clazz.getName() + ": could not find any public methods annotated with " + FunctionInvocation.class.getName());
        }
    }

    public String executeFunction(String functionName, String ... arguments) throws InvocationTargetException, IllegalAccessException {
        Method method = this.getMethod(functionName, arguments);
        return this.executeMethod(method, arguments);
    }

    private String executeMethod(Method method, String ... arguments) throws InvocationTargetException, IllegalAccessException {
        Object instance = this.methodInstanceMap.get(method);
        if (method.getParameterTypes().length == 1 && method.getParameterTypes()[0].equals(String[].class)) {
            return method.invoke(instance, new Object[]{arguments}).toString();
        }
        return method.invoke(instance, (Object[])arguments).toString();
    }

    public Method getMethod(String functionName, String ... arguments) throws IllegalArgumentException {
        ArrayList classList = new ArrayList();
        if (arguments != null) {
            for (String argument : arguments) {
                if (argument == null) continue;
                classList.add(argument.getClass());
            }
        }
        MethodAndObjectHolder holder = null;
        try {
            holder = this.getHolder(functionName, classList);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
        if (holder == null) {
            throw new IllegalArgumentException("could not find method to invoke.");
        }
        return holder.getMethod();
    }

    private MethodAndObjectHolder getHolder(String functionName, List<Class<?>> classList) throws IllegalAccessException {
        MethodAndObjectHolder holder = this.functionInvocationHolderMethodConcurrentHashMap.get(new FunctionInvocationHolder(functionName, classList.toArray(new Class[classList.size()])));
        if (holder == null) {
            holder = this.functionInvocationHolderMethodConcurrentHashMap.get(new FunctionInvocationHolder(functionName, new Class[]{String[].class}));
        }
        return holder;
    }

    private static final class FunctionInvocationHolder {
        private final String functionName;
        private final Class<?>[] parameterTypes;

        private FunctionInvocationHolder(String functionName, Class<?>[] parameterTypes) {
            Validate.notNull((Object)functionName, (String)"a function name must be provided");
            Validate.notNull(parameterTypes, (String)"parameter types must be provided");
            this.functionName = functionName;
            this.parameterTypes = parameterTypes;
        }

        public String getFunctionName() {
            return this.functionName;
        }

        public Class<?>[] getParameterTypes() {
            return this.parameterTypes;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            FunctionInvocationHolder functionInvocationHolder = (FunctionInvocationHolder)obj;
            return new EqualsBuilder().append((Object)this.functionName, (Object)functionInvocationHolder.functionName).append((Object[])this.parameterTypes, (Object[])functionInvocationHolder.parameterTypes).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder(5, 33).append((Object)this.functionName).append((Object[])this.parameterTypes).toHashCode();
        }
    }

    private static final class MethodAndObjectHolder {
        private final Method method;
        private final Object instance;

        private MethodAndObjectHolder(Method method, Object instance) {
            this.method = method;
            this.instance = instance;
        }

        public Method getMethod() {
            return this.method;
        }

        public Object getInstance() {
            return this.instance;
        }
    }
}

