/*
 * Decompiled with CFR 0.152.
 */
package com.github.vincentrussell.json.datagenerator.functions.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang.time.DateUtils;

public abstract class AbstractAddDates {
    private Method method;

    protected String addInterval(String format, String date, String interval) {
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat(format);
            Date myDate = dateFormat.parse(date);
            return dateFormat.format(this.addInterval(myDate, Integer.valueOf(interval)));
        }
        catch (NullPointerException | NumberFormatException | ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected String addInterval(String date, String interval) {
        return this.addInterval("dd-MM-yyyy HH:mm:ss", date, interval);
    }

    private synchronized Method getMethod() throws NoSuchMethodException {
        return DateUtils.class.getMethod(this.getMethodName(), Date.class, Integer.TYPE);
    }

    private Date addInterval(Date oldDate, Integer amount) {
        try {
            if (this.method == null) {
                this.method = this.getMethod();
                this.method.setAccessible(true);
            }
            return (Date)this.method.invoke(null, oldDate, amount);
        }
        catch (IllegalAccessException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected abstract String getMethodName();
}

