/*
 * Decompiled with CFR 0.152.
 */
package com.github.vincentrussell.json.datagenerator.functions.impl;

import com.github.vincentrussell.json.datagenerator.functions.Function;
import com.github.vincentrussell.json.datagenerator.functions.FunctionInvocation;
import com.github.vincentrussell.json.datagenerator.impl.IndexHolder;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Function(name={"index"})
public class Index {
    static final Map<String, IndexHolder> STRING_INDEX_HOLDER_MAP = new ConcurrentHashMap<String, IndexHolder>();
    static final String DEFAULT = "DEFAULT";

    @FunctionInvocation
    public String getIndex() {
        return this.getIndex(DEFAULT);
    }

    @FunctionInvocation
    public String getIndex(String indexName) {
        try {
            return this.getIndex(DEFAULT, Integer.parseInt(indexName));
        }
        catch (NumberFormatException e) {
            return "" + this.getIndexHolder(indexName).getNextIndex();
        }
    }

    @FunctionInvocation
    public String getIndex(String indexName, String startingPoint) {
        return this.getIndex(indexName, Integer.parseInt(startingPoint));
    }

    private String getIndex(String indexName, int startingPoint) {
        return "" + this.getIndexHolder(indexName, startingPoint).getNextIndex();
    }

    private IndexHolder getIndexHolder(String indexName) {
        return this.getIndexHolder(indexName, 0);
    }

    private IndexHolder getIndexHolder(String indexName, int startingPoint) {
        if (STRING_INDEX_HOLDER_MAP.containsKey(indexName)) {
            return STRING_INDEX_HOLDER_MAP.get(indexName);
        }
        IndexHolder indexHolder = new IndexHolder(startingPoint);
        STRING_INDEX_HOLDER_MAP.put(indexName, indexHolder);
        return indexHolder;
    }
}

