/*
 * Decompiled with CFR 0.152.
 */
package com.github.vincentrussell.json.datagenerator.functions.impl;

import com.github.vincentrussell.json.datagenerator.functions.Function;
import com.github.vincentrussell.json.datagenerator.functions.FunctionInvocation;
import java.util.Random;

@Function(name={"float", "floating"})
public class RandomFloat {
    private static final Random RANDOM = new Random();

    private String getRandomFloat(Float min, Float max, String format) {
        float randomNumber = min.floatValue() + (max.floatValue() - min.floatValue()) * RANDOM.nextFloat();
        if (format != null) {
            return String.format(format, Float.valueOf(randomNumber));
        }
        return Float.toString(randomNumber);
    }

    @FunctionInvocation
    public String getRandomFloat(String min, String max) {
        return this.getRandomFloat(min, max, null);
    }

    @FunctionInvocation
    public String getRandomFloat(String min, String max, String format) {
        return this.getRandomFloat(Float.valueOf(Float.parseFloat(min)), Float.valueOf(Float.parseFloat(max)), format);
    }
}

