/*
 * Decompiled with CFR 0.152.
 */
package com.github.vincentrussell.json.datagenerator.impl;

import com.google.common.base.Charsets;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class ByteArrayBackupToFileOutputStream
extends OutputStream {
    private static final int DEFAULT_INITIAL_BUFFER_SIZE = 1028;
    private static final int DEFAULT_SIZE_BEFORE_OVER_FLOW = 1024000;
    private byte[] buf;
    private int count;
    private final int sizeBeforeOverFlow;
    private File file = null;
    private FileOutputStream fileOutputStream = null;
    private long lastMark = 0L;

    public ByteArrayBackupToFileOutputStream() {
        this(1028, 1024000);
    }

    public ByteArrayBackupToFileOutputStream(int initialBufferSize, int sizeBeforeOverFlow) {
        if (sizeBeforeOverFlow < 0) {
            throw new IllegalArgumentException("Negative initial sizeBeforeOverFlow: " + sizeBeforeOverFlow);
        }
        this.buf = new byte[initialBufferSize];
        this.sizeBeforeOverFlow = sizeBeforeOverFlow;
    }

    private void ensureCapacity(int minCapacity) throws IOException {
        if (this.buf != null && minCapacity - this.buf.length > 0 && minCapacity <= this.sizeBeforeOverFlow) {
            this.grow(minCapacity);
            return;
        }
        if (minCapacity > this.sizeBeforeOverFlow && this.file == null) {
            this.file = File.createTempFile("temp", "temp");
            this.fileOutputStream = new FileOutputStream(this.file);
            this.fileOutputStream.write(this.buf);
            this.buf = null;
            return;
        }
    }

    private void grow(int minCapacity) {
        int oldCapacity = this.buf.length;
        int newCapacity = oldCapacity << 1;
        if (newCapacity > this.sizeBeforeOverFlow) {
            newCapacity = this.sizeBeforeOverFlow;
        }
        if (newCapacity - minCapacity < 0) {
            newCapacity = minCapacity;
        }
        if (newCapacity < 0) {
            if (minCapacity < 0) {
                throw new OutOfMemoryError();
            }
            newCapacity = Integer.MAX_VALUE;
        }
        this.buf = Arrays.copyOf(this.buf, newCapacity);
    }

    @Override
    public synchronized void write(int b) throws IOException {
        this.ensureCapacity(this.count + 1);
        if (this.buf == null) {
            this.fileOutputStream.write(b);
            return;
        }
        this.buf[this.count] = (byte)b;
        ++this.count;
    }

    public void unwrite() throws IOException {
        if (this.count == 0) {
            throw new IOException("Pushback buffer overflow");
        }
        if (this.buf == null) {
            RandomAccessFile randomAccessFile = new RandomAccessFile(this.file, "rw");
            randomAccessFile.setLength(this.file.length() - 1L);
            return;
        }
        this.buf[--this.count] = 0;
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        if (off < 0 || off > b.length || len < 0 || off + len - b.length > 0) {
            throw new IndexOutOfBoundsException();
        }
        this.ensureCapacity(this.count + len);
        if (this.buf == null) {
            this.fileOutputStream.write(b);
            return;
        }
        System.arraycopy(b, off, this.buf, this.count, len);
        this.count += len;
    }

    public synchronized int size() {
        return this.count;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized String toString() {
        if (this.buf != null) return new String(this.buf, 0, this.count, Charsets.UTF_8);
        try (FileInputStream inputStream = new FileInputStream(this.file);){
            StringWriter writer = new StringWriter();
            IOUtils.copy((InputStream)inputStream, (Writer)writer, (String)"UTF-8");
            String string = writer.toString();
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.fileOutputStream != null) {
            this.fileOutputStream.close();
        }
        if (this.file != null) {
            FileUtils.forceDelete((File)this.file);
        }
    }

    public InputStream getNewInputStream() throws IOException {
        if (this.buf != null) {
            return new ByteArrayInputStream(Arrays.copyOf(this.buf, this.count));
        }
        this.fileOutputStream.flush();
        return new FileInputStream(this.file);
    }

    public void mark() throws IOException {
        this.lastMark = this.getLength();
    }

    public void reset() throws IOException {
        if (this.lastMark <= 0L) {
            throw new IOException("mark has not been set yet.");
        }
        this.setLength(this.lastMark);
    }

    private void shrink(int newCapacity) {
        this.buf = Arrays.copyOf(this.buf, newCapacity);
        this.count = newCapacity;
    }

    public void setLength(long length) throws IOException {
        if (this.buf != null) {
            if (length > (long)this.buf.length) {
                throw new IllegalStateException("length: " + length + " is greater than buffer length");
            }
            this.shrink((int)length);
        } else {
            if (length > this.file.length()) {
                throw new IllegalStateException("length: " + length + " is greater than file length");
            }
            RandomAccessFile randomAccessFile = new RandomAccessFile(this.file, "rw");
            randomAccessFile.setLength(length);
            this.fileOutputStream = new FileOutputStream(this.file, true);
        }
    }

    public long getLength() {
        if (this.buf != null) {
            return this.count;
        }
        return this.file.length();
    }
}

