/*
 * Decompiled with CFR 0.152.
 */
package com.github.vincentrussell.json.datagenerator.impl;

import com.github.vincentrussell.json.datagenerator.JsonDataGenerator;
import com.github.vincentrussell.json.datagenerator.JsonDataGeneratorException;
import com.github.vincentrussell.json.datagenerator.impl.ByteArrayBackupToFileOutputStream;
import com.github.vincentrussell.json.datagenerator.impl.FunctionReplacingReader;
import com.github.vincentrussell.json.datagenerator.impl.FunctionTokenResolver;
import com.google.common.base.Charsets;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections4.queue.CircularFifoQueue;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.Validate;

public class JsonDataGeneratorImpl
implements JsonDataGenerator {
    public static final String REPEAT = "'{{repeat(";
    private static final String REPEAT_TEXT = "'{{repeat(";
    private static final byte[] CLOSE_BRACKET_BYTE_ARRAY = "]".getBytes(Charsets.UTF_8);
    private static final byte[] COMMA_NEWLINE_BYTE_ARRAY = ",\n".getBytes(Charsets.UTF_8);
    private static final byte[] NEWLINE_BYTE_ARRAY = "\n".getBytes(Charsets.UTF_8);
    public static final int DEFAULT_READ_AHEAD_LIMIT = 1000;
    private static Pattern REPEAT_PARAMETERS_PATTERN = Pattern.compile("^(\\d+),*\\s*(\\d+)*$");

    @Override
    public void generateTestDataJson(String text, OutputStream outputStream) throws JsonDataGeneratorException {
        try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(text.getBytes(Charsets.UTF_8));){
            this.generateTestDataJson(byteArrayInputStream, outputStream);
        }
        catch (JsonDataGeneratorException | IOException e) {
            throw new JsonDataGeneratorException(e);
        }
    }

    @Override
    public void generateTestDataJson(URL classPathResource, OutputStream outputStream) throws JsonDataGeneratorException {
        try {
            this.generateTestDataJson(classPathResource.openStream(), outputStream);
        }
        catch (IOException e) {
            throw new JsonDataGeneratorException(e);
        }
    }

    @Override
    public void generateTestDataJson(File file, OutputStream outputStream) throws JsonDataGeneratorException {
        Validate.notNull((Object)file, (String)"file can not be null");
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            this.generateTestDataJson(fileInputStream, outputStream);
        }
        catch (IOException e) {
            throw new JsonDataGeneratorException(e);
        }
    }

    @Override
    public void generateTestDataJson(File file, File outputFile) throws JsonDataGeneratorException {
        Validate.notNull((Object)file, (String)"file can not be null");
        Validate.notNull((Object)outputFile, (String)"outputFile can not be null");
        Validate.isTrue((!outputFile.exists() ? 1 : 0) != 0, (String)"outputFile can not exist");
        try (FileInputStream fileInputStream = new FileInputStream(file);
             FileOutputStream fileOutputStream = new FileOutputStream(outputFile);){
            this.generateTestDataJson(fileInputStream, (OutputStream)fileOutputStream);
        }
        catch (IOException e) {
            throw new JsonDataGeneratorException(e);
        }
    }

    @Override
    public void generateTestDataJson(InputStream inputStream, OutputStream outputStream) throws JsonDataGeneratorException {
        try (ByteArrayBackupToFileOutputStream byteArrayBackupToFileOutputStream = new ByteArrayBackupToFileOutputStream();){
            this.handleRepeats(inputStream, byteArrayBackupToFileOutputStream);
            try (InputStream copyInputStream = byteArrayBackupToFileOutputStream.getNewInputStream();){
                this.handleNestedFunctions(copyInputStream, outputStream);
            }
        }
        catch (IOException e) {
            throw new JsonDataGeneratorException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleRepeats(InputStream inputStream, OutputStream outputStream) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, Charsets.UTF_8));
        CircularFifoQueue lastCharQueue = new CircularFifoQueue("'{{repeat(".length());
        LinkedList<Character> xmlRepeatTagList = new LinkedList<Character>();
        boolean isRepeating = false;
        int bracketCount = 0;
        int repeatTimes = 0;
        int firstNonWhitespaceCharacter = -1;
        int xmlTag = 0;
        String xmlRepeatTag = "";
        try (ByteArrayBackupToFileOutputStream tempBuffer = new ByteArrayBackupToFileOutputStream();
             ByteArrayBackupToFileOutputStream repeatBuffer = new ByteArrayBackupToFileOutputStream();){
            int i;
            while ((i = bufferedReader.read()) != -1) {
                String charAsUTF8String = Character.valueOf((char)i).toString();
                if (isRepeating) {
                    InputStream recursiveOutputStreamNewInputStream;
                    Throwable throwable;
                    InputStream newCopyOutputStreamNewInputStream;
                    ByteArrayBackupToFileOutputStream recursiveOutputStream;
                    Throwable throwable2;
                    InputStream repeatBufferNewInputStream;
                    Throwable throwable3;
                    ByteArrayBackupToFileOutputStream newCopyOutputStream;
                    block255: {
                        repeatBuffer.write(charAsUTF8String.getBytes(Charsets.UTF_8));
                        if (!Character.isWhitespace(i) && firstNonWhitespaceCharacter == -1) {
                            firstNonWhitespaceCharacter = i;
                        }
                        if (123 == i) {
                            ++bracketCount;
                        } else if (125 == i || 93 == i && bracketCount == 0) {
                            if (--bracketCount == 0 && xmlTag == 0) {
                                bufferedReader.mark(1);
                                i = bufferedReader.read();
                                charAsUTF8String = Character.valueOf((char)i).toString();
                                if (i == firstNonWhitespaceCharacter) {
                                    repeatBuffer.write(charAsUTF8String.getBytes(Charsets.UTF_8));
                                } else {
                                    bufferedReader.reset();
                                }
                                newCopyOutputStream = new ByteArrayBackupToFileOutputStream();
                                throwable3 = null;
                                try {
                                    repeatBufferNewInputStream = repeatBuffer.getNewInputStream();
                                    throwable2 = null;
                                    try {
                                        IOUtils.copy((InputStream)repeatBufferNewInputStream, (OutputStream)newCopyOutputStream);
                                    }
                                    catch (Throwable throwable4) {
                                        throwable2 = throwable4;
                                        throw throwable4;
                                    }
                                    finally {
                                        if (repeatBufferNewInputStream != null) {
                                            if (throwable2 != null) {
                                                try {
                                                    repeatBufferNewInputStream.close();
                                                }
                                                catch (Throwable throwable5) {
                                                    throwable2.addSuppressed(throwable5);
                                                }
                                            } else {
                                                repeatBufferNewInputStream.close();
                                            }
                                        }
                                    }
                                    this.copyRepeatStream(repeatTimes, repeatBuffer, newCopyOutputStream, COMMA_NEWLINE_BYTE_ARRAY);
                                    recursiveOutputStream = new ByteArrayBackupToFileOutputStream();
                                    throwable2 = null;
                                    try {
                                        newCopyOutputStreamNewInputStream = newCopyOutputStream.getNewInputStream();
                                        throwable = null;
                                        try {
                                            this.handleRepeats(newCopyOutputStreamNewInputStream, recursiveOutputStream);
                                        }
                                        catch (Throwable throwable6) {
                                            throwable = throwable6;
                                            throw throwable6;
                                        }
                                        finally {
                                            if (newCopyOutputStreamNewInputStream != null) {
                                                if (throwable != null) {
                                                    try {
                                                        newCopyOutputStreamNewInputStream.close();
                                                    }
                                                    catch (Throwable throwable7) {
                                                        throwable.addSuppressed(throwable7);
                                                    }
                                                } else {
                                                    newCopyOutputStreamNewInputStream.close();
                                                }
                                            }
                                        }
                                        recursiveOutputStreamNewInputStream = recursiveOutputStream.getNewInputStream();
                                        throwable = null;
                                        try {
                                            IOUtils.copy((InputStream)recursiveOutputStreamNewInputStream, (OutputStream)outputStream);
                                        }
                                        catch (Throwable throwable8) {
                                            throwable = throwable8;
                                            throw throwable8;
                                        }
                                        finally {
                                            if (recursiveOutputStreamNewInputStream != null) {
                                                if (throwable != null) {
                                                    try {
                                                        recursiveOutputStreamNewInputStream.close();
                                                    }
                                                    catch (Throwable throwable9) {
                                                        throwable.addSuppressed(throwable9);
                                                    }
                                                } else {
                                                    recursiveOutputStreamNewInputStream.close();
                                                }
                                            }
                                        }
                                        repeatBuffer.setLength(0L);
                                        tempBuffer.setLength(0L);
                                        isRepeating = false;
                                        bracketCount = 0;
                                        break block255;
                                    }
                                    catch (Throwable recursiveOutputStreamNewInputStream2) {
                                        throwable2 = recursiveOutputStreamNewInputStream2;
                                        throw recursiveOutputStreamNewInputStream2;
                                    }
                                    finally {
                                        if (recursiveOutputStream != null) {
                                            if (throwable2 != null) {
                                                try {
                                                    recursiveOutputStream.close();
                                                }
                                                catch (Throwable recursiveOutputStreamNewInputStream2) {
                                                    throwable2.addSuppressed(recursiveOutputStreamNewInputStream2);
                                                }
                                            } else {
                                                recursiveOutputStream.close();
                                            }
                                        }
                                    }
                                }
                                catch (Throwable recursiveOutputStream2) {
                                    throwable3 = recursiveOutputStream2;
                                    throw recursiveOutputStream2;
                                }
                                finally {
                                    if (newCopyOutputStream != null) {
                                        if (throwable3 != null) {
                                            try {
                                                newCopyOutputStream.close();
                                            }
                                            catch (Throwable recursiveOutputStream2) {
                                                throwable3.addSuppressed(recursiveOutputStream2);
                                            }
                                        } else {
                                            newCopyOutputStream.close();
                                        }
                                    }
                                }
                            }
                            if (bracketCount == -1) {
                                repeatBuffer.setLength(repeatBuffer.getLength() - 1L);
                                throwable3 = null;
                                try (ByteArrayBackupToFileOutputStream newCopyFileStream = new ByteArrayBackupToFileOutputStream();){
                                    repeatBufferNewInputStream = repeatBuffer.getNewInputStream();
                                    throwable2 = null;
                                    try {
                                        IOUtils.copy((InputStream)repeatBufferNewInputStream, (OutputStream)newCopyFileStream);
                                    }
                                    catch (Throwable recursiveOutputStreamNewInputStream2) {
                                        throwable2 = recursiveOutputStreamNewInputStream2;
                                        throw recursiveOutputStreamNewInputStream2;
                                    }
                                    finally {
                                        if (repeatBufferNewInputStream != null) {
                                            if (throwable2 != null) {
                                                try {
                                                    repeatBufferNewInputStream.close();
                                                }
                                                catch (Throwable recursiveOutputStreamNewInputStream2) {
                                                    throwable2.addSuppressed(recursiveOutputStreamNewInputStream2);
                                                }
                                            } else {
                                                repeatBufferNewInputStream.close();
                                            }
                                        }
                                    }
                                    this.copyRepeatStream(repeatTimes, repeatBuffer, newCopyFileStream, COMMA_NEWLINE_BYTE_ARRAY);
                                    newCopyFileStream.write(CLOSE_BRACKET_BYTE_ARRAY);
                                    recursiveOutputStream = new ByteArrayBackupToFileOutputStream();
                                    throwable2 = null;
                                    try {
                                        throwable = null;
                                        try (InputStream inputStream1 = newCopyFileStream.getNewInputStream();){
                                            this.handleRepeats(inputStream1, recursiveOutputStream);
                                        }
                                        catch (Throwable throwable10) {
                                            throwable = throwable10;
                                            throw throwable10;
                                        }
                                        inputStream1 = recursiveOutputStream.getNewInputStream();
                                        throwable = null;
                                        try {
                                            IOUtils.copy((InputStream)inputStream1, (OutputStream)outputStream);
                                        }
                                        catch (Throwable throwable11) {
                                            throwable = throwable11;
                                            throw throwable11;
                                        }
                                        finally {
                                            if (inputStream1 != null) {
                                                if (throwable != null) {
                                                    try {
                                                        inputStream1.close();
                                                    }
                                                    catch (Throwable throwable12) {
                                                        throwable.addSuppressed(throwable12);
                                                    }
                                                } else {
                                                    inputStream1.close();
                                                }
                                            }
                                        }
                                    }
                                    catch (Throwable inputStream1) {
                                        throwable2 = inputStream1;
                                        throw inputStream1;
                                    }
                                    finally {
                                        if (recursiveOutputStream != null) {
                                            if (throwable2 != null) {
                                                try {
                                                    recursiveOutputStream.close();
                                                }
                                                catch (Throwable inputStream1) {
                                                    throwable2.addSuppressed(inputStream1);
                                                }
                                            } else {
                                                recursiveOutputStream.close();
                                            }
                                        }
                                    }
                                    repeatBuffer.setLength(0L);
                                    tempBuffer.setLength(0L);
                                    isRepeating = false;
                                    bracketCount = 0;
                                }
                                catch (Throwable recursiveOutputStream3) {
                                    throwable3 = recursiveOutputStream3;
                                    throw recursiveOutputStream3;
                                }
                            }
                        }
                    }
                    if (60 == i && xmlTag == 0) {
                        i = bufferedReader.read();
                        while (62 != i && i != -1) {
                            charAsUTF8String = Character.valueOf((char)i).toString();
                            xmlRepeatTagList.add(Character.valueOf((char)i));
                            repeatBuffer.write(charAsUTF8String.getBytes(Charsets.UTF_8));
                            i = bufferedReader.read();
                            charAsUTF8String = Character.valueOf((char)i).toString();
                        }
                        ++xmlTag;
                        repeatBuffer.write(charAsUTF8String.getBytes(Charsets.UTF_8));
                        xmlRepeatTag = "</" + this.readAsString(xmlRepeatTagList) + ">";
                    }
                    if (repeatBuffer.getLength() > 0L && !xmlRepeatTag.isEmpty() && repeatBuffer.toString().endsWith(xmlRepeatTag)) {
                        newCopyOutputStream = new ByteArrayBackupToFileOutputStream();
                        throwable3 = null;
                        try {
                            repeatBufferNewInputStream = repeatBuffer.getNewInputStream();
                            throwable2 = null;
                            try {
                                IOUtils.copy((InputStream)repeatBufferNewInputStream, (OutputStream)newCopyOutputStream);
                            }
                            catch (Throwable inputStream1) {
                                throwable2 = inputStream1;
                                throw inputStream1;
                            }
                            finally {
                                if (repeatBufferNewInputStream != null) {
                                    if (throwable2 != null) {
                                        try {
                                            repeatBufferNewInputStream.close();
                                        }
                                        catch (Throwable inputStream1) {
                                            throwable2.addSuppressed(inputStream1);
                                        }
                                    } else {
                                        repeatBufferNewInputStream.close();
                                    }
                                }
                            }
                            this.copyRepeatStream(repeatTimes, repeatBuffer, newCopyOutputStream, NEWLINE_BYTE_ARRAY);
                            recursiveOutputStream = new ByteArrayBackupToFileOutputStream();
                            throwable2 = null;
                            try {
                                newCopyOutputStreamNewInputStream = newCopyOutputStream.getNewInputStream();
                                throwable = null;
                                try {
                                    this.handleRepeats(newCopyOutputStreamNewInputStream, recursiveOutputStream);
                                }
                                catch (Throwable throwable13) {
                                    throwable = throwable13;
                                    throw throwable13;
                                }
                                finally {
                                    if (newCopyOutputStreamNewInputStream != null) {
                                        if (throwable != null) {
                                            try {
                                                newCopyOutputStreamNewInputStream.close();
                                            }
                                            catch (Throwable throwable14) {
                                                throwable.addSuppressed(throwable14);
                                            }
                                        } else {
                                            newCopyOutputStreamNewInputStream.close();
                                        }
                                    }
                                }
                                recursiveOutputStreamNewInputStream = recursiveOutputStream.getNewInputStream();
                                throwable = null;
                                try {
                                    IOUtils.copy((InputStream)recursiveOutputStreamNewInputStream, (OutputStream)outputStream);
                                }
                                catch (Throwable throwable15) {
                                    throwable = throwable15;
                                    throw throwable15;
                                }
                                finally {
                                    if (recursiveOutputStreamNewInputStream != null) {
                                        if (throwable != null) {
                                            try {
                                                recursiveOutputStreamNewInputStream.close();
                                            }
                                            catch (Throwable throwable16) {
                                                throwable.addSuppressed(throwable16);
                                            }
                                        } else {
                                            recursiveOutputStreamNewInputStream.close();
                                        }
                                    }
                                }
                                repeatBuffer.setLength(0L);
                                tempBuffer.setLength(0L);
                                isRepeating = false;
                                bracketCount = 0;
                                xmlTag = 0;
                            }
                            catch (Throwable throwable17) {
                                throwable2 = throwable17;
                                throw throwable17;
                            }
                            finally {
                                if (recursiveOutputStream != null) {
                                    if (throwable2 != null) {
                                        try {
                                            recursiveOutputStream.close();
                                        }
                                        catch (Throwable throwable18) {
                                            throwable2.addSuppressed(throwable18);
                                        }
                                    } else {
                                        recursiveOutputStream.close();
                                    }
                                }
                            }
                        }
                        catch (Throwable throwable19) {
                            throwable3 = throwable19;
                            throw throwable19;
                        }
                        finally {
                            if (newCopyOutputStream != null) {
                                if (throwable3 != null) {
                                    try {
                                        newCopyOutputStream.close();
                                    }
                                    catch (Throwable throwable20) {
                                        throwable3.addSuppressed(throwable20);
                                    }
                                } else {
                                    newCopyOutputStream.close();
                                }
                            }
                        }
                    }
                } else {
                    tempBuffer.write(charAsUTF8String.getBytes(Charsets.UTF_8));
                    lastCharQueue.add((Object)Character.valueOf((char)i));
                }
                if (lastCharQueue.peek() == null || !((Character)lastCharQueue.peek()).equals(Character.valueOf('\'')) || !"'{{repeat(".equals(this.readAsString((CircularFifoQueue<Character>)lastCharQueue))) continue;
                tempBuffer.mark();
                bufferedReader.mark(1000);
                try {
                    i = bufferedReader.read();
                    charAsUTF8String = Character.valueOf((char)i).toString();
                    tempBuffer.write(charAsUTF8String.getBytes());
                    String numRepeats = "";
                    while (i != 41) {
                        numRepeats = numRepeats + Character.toString((char)i);
                        i = bufferedReader.read();
                        charAsUTF8String = Character.valueOf((char)i).toString();
                        if (i == 41) continue;
                        tempBuffer.write(charAsUTF8String.getBytes());
                    }
                    tempBuffer.write((char)i);
                    i = bufferedReader.read();
                    tempBuffer.write((char)i);
                    if (i != 125) {
                        throw new IllegalStateException();
                    }
                    i = bufferedReader.read();
                    tempBuffer.write((char)i);
                    if (i != 125) {
                        throw new IllegalStateException();
                    }
                    i = bufferedReader.read();
                    tempBuffer.write((char)i);
                    if (i != 39) {
                        throw new IllegalStateException();
                    }
                    i = bufferedReader.read();
                    tempBuffer.write((char)i);
                    if (i != 44) {
                        throw new IllegalStateException();
                    }
                    repeatTimes = this.parseRepeats(numRepeats);
                    tempBuffer.setLength(tempBuffer.getLength() - (long)numRepeats.length() - (long)lastCharQueue.size() - 5L);
                    try (InputStream tempBufferNewInputStream = tempBuffer.getNewInputStream();){
                        IOUtils.copy((InputStream)tempBufferNewInputStream, (OutputStream)outputStream);
                    }
                    tempBuffer.setLength(0L);
                    repeatBuffer.setLength(0L);
                    isRepeating = true;
                    bracketCount = 0;
                    lastCharQueue.clear();
                    xmlRepeatTagList.clear();
                }
                catch (IllegalStateException e) {
                    this.setQueueCharacters((CircularFifoQueue<Character>)lastCharQueue, "'{{repeat(");
                    bufferedReader.reset();
                    tempBuffer.reset();
                }
            }
            bufferedReader.close();
            try (InputStream inputStream1 = tempBuffer.getNewInputStream();){
                IOUtils.copy((InputStream)inputStream1, (OutputStream)outputStream);
                return;
            }
        }
        finally {
            bufferedReader.close();
        }
    }

    private void copyRepeatStream(int repeatTimes, ByteArrayBackupToFileOutputStream repeatBuffer, ByteArrayBackupToFileOutputStream newCopyFileStream, byte[] separatorBytes) throws IOException {
        for (int j = 1; j < repeatTimes; ++j) {
            newCopyFileStream.write(separatorBytes);
            try (InputStream repeatBufferInputStream = repeatBuffer.getNewInputStream();){
                IOUtils.copy((InputStream)repeatBufferInputStream, (OutputStream)newCopyFileStream);
                continue;
            }
        }
    }

    private int parseRepeats(String repeatArguments) {
        Matcher matcher = REPEAT_PARAMETERS_PATTERN.matcher(repeatArguments);
        if (matcher.find()) {
            Integer integer = Integer.parseInt(matcher.group(1));
            Integer integer2 = Integer.parseInt(matcher.group(1));
            if (matcher.group(2) == null) {
                if (integer >= integer2 && !integer.equals(integer2)) {
                    throw new IllegalArgumentException("the second number must be greater than the first number" + repeatArguments);
                }
                return integer;
            }
            integer2 = Integer.parseInt(matcher.group(2));
            if (integer.equals(integer2)) {
                return integer;
            }
            return new Random().nextInt(integer2 - integer) + integer;
        }
        throw new IllegalArgumentException("invalid arguments for repeat function: " + repeatArguments);
    }

    private String readAsString(CircularFifoQueue<Character> characters) {
        char[] charArray = new char[characters.size()];
        for (int i = 0; i < charArray.length; ++i) {
            charArray[i] = ((Character)characters.get(i)).charValue();
        }
        return new String(charArray);
    }

    private String readAsString(List<Character> characters) {
        char[] charArray = new char[characters.size()];
        for (int i = 0; i < charArray.length; ++i) {
            charArray[i] = characters.get(i).charValue();
        }
        return new String(charArray);
    }

    private void setQueueCharacters(CircularFifoQueue<Character> characters, String string) {
        characters.clear();
        char[] charArray = string.toCharArray();
        for (int i = 0; i < charArray.length; ++i) {
            characters.add((Object)Character.valueOf(charArray[i]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleNestedFunctions(InputStream inputStream, OutputStream outputStream) throws IOException {
        FunctionReplacingReader reader = new FunctionReplacingReader(new InputStreamReader(inputStream, Charsets.UTF_8), new FunctionTokenResolver());
        int data = 0;
        try {
            while ((data = ((Reader)reader).read()) != -1) {
                String charAsUTF8String = Character.valueOf((char)data).toString();
                outputStream.write(charAsUTF8String.getBytes(Charsets.UTF_8));
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
            IOUtils.closeQuietly((Reader)reader);
        }
    }
}

