/*
 * Decompiled with CFR 0.152.
 */
package org.actressframework.core;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.actressframework.core.ThreadProvider;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.LoggerFactory;

@Aspect
public class ActorInterceptor {
    private static boolean actorsEnabled = true;
    private ThreadProvider threadProvider = ThreadProvider.instance();

    @Around(value="execution(!private * (@org.actressframework.core.Actor *).*(..))")
    public Object actorMethodCall(ProceedingJoinPoint joinPoint) throws Throwable {
        if (this.doInActorThread(joinPoint)) {
            if (this.hasNoReturnValue(joinPoint)) {
                return this.callNonBlocking(joinPoint);
            }
            return this.callBlocking(joinPoint);
        }
        return this.callInCurrentThread(joinPoint);
    }

    private boolean doInActorThread(ProceedingJoinPoint joinPoint) {
        return actorsEnabled && this.isMethodCall(joinPoint) && !this.alreadyInActorThread(joinPoint);
    }

    private boolean isMethodCall(ProceedingJoinPoint joinPoint) {
        return joinPoint.getTarget() != null && joinPoint.getSignature() instanceof MethodSignature;
    }

    private boolean alreadyInActorThread(ProceedingJoinPoint joinPoint) {
        return this.threadProvider.inActorThread(joinPoint.getTarget());
    }

    private boolean hasNoReturnValue(ProceedingJoinPoint joinPoint) {
        return ((MethodSignature)joinPoint.getSignature()).getReturnType().equals(Void.TYPE);
    }

    private Object callNonBlocking(final ProceedingJoinPoint joinPoint) {
        this.threadProvider.provide(joinPoint.getTarget()).execute(new Runnable(){

            @Override
            public void run() {
                ActorInterceptor.this.doActualCall(joinPoint);
            }
        });
        return null;
    }

    private Object callBlocking(final ProceedingJoinPoint joinPoint) throws InterruptedException, ExecutionException {
        Future future = this.threadProvider.provide(joinPoint.getTarget()).submit((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return ActorInterceptor.this.doActualCall(joinPoint);
            }
        });
        return future.get();
    }

    private Object callInCurrentThread(ProceedingJoinPoint joinPoint) throws Throwable {
        return joinPoint.proceed();
    }

    private Object doActualCall(ProceedingJoinPoint joinPoint) {
        try {
            return this.callInCurrentThread(joinPoint);
        }
        catch (Throwable e) {
            LoggerFactory.getLogger(joinPoint.getTarget().getClass()).error(e.getMessage(), e);
            throw new RuntimeException(e);
        }
    }

    public static void enableActors() {
        actorsEnabled = true;
    }

    public static void disableActors() {
        actorsEnabled = false;
    }
}

