/*
 * Decompiled with CFR 0.152.
 */
package org.actressframework.core;

import org.actressframework.common.SingleThread;
import org.actressframework.core.ThreadFactory;

class RoundRobinThreadFactory
extends ThreadFactory {
    private SingleThread[] threadPool;
    private int currentIndex = 0;

    RoundRobinThreadFactory(int size) {
        this.threadPool = new SingleThread[size];
    }

    @Override
    synchronized SingleThread create(Object target) {
        SingleThread thread = this.threadPool[this.currentIndex];
        if (thread == null) {
            thread = SingleThread.singleThread((String)("Actor-Pool-" + this.currentIndex));
        }
        this.currentIndex += 1 % this.threadPool.length;
        return thread;
    }
}

