/*
 * Decompiled with CFR 0.152.
 */
package org.actressframework.core;

import java.util.HashMap;
import java.util.Map;
import org.actressframework.common.SingleThread;
import org.actressframework.core.ThreadFactory;

class ThreadProvider {
    private ThreadFactory threadFactory = ThreadFactory.instance();
    private Map<Object, SingleThread> threads = new HashMap<Object, SingleThread>();

    private ThreadProvider() {
    }

    static ThreadProvider instance() {
        return new ThreadProvider();
    }

    synchronized SingleThread provide(Object target) {
        SingleThread thread = this.threads.get(target);
        if (thread == null) {
            thread = this.threadFactory.create(target);
            this.threads.put(target, thread);
        }
        return thread;
    }

    boolean inActorThread(Object target) {
        return this.provide(target).matches(Thread.currentThread());
    }
}

