/*
 * Decompiled with CFR 0.152.
 */
package msgpack4z;

import java.io.Serializable;
import msgpack4z.CodecPlay2JsArray;
import msgpack4z.CodecPlay2JsObject;
import msgpack4z.CodecPlay2JsValue;
import msgpack4z.MsgPacker;
import msgpack4z.MsgType;
import msgpack4z.MsgUnpacker;
import msgpack4z.MsgpackCodec;
import msgpack4z.Other;
import msgpack4z.Play2Msgpack;
import msgpack4z.Play2Msgpack$Result$;
import msgpack4z.PlayUnpackOptions;
import msgpack4z.UnpackError;
import play.api.libs.json.JsArray;
import play.api.libs.json.JsBoolean;
import play.api.libs.json.JsBoolean$;
import play.api.libs.json.JsNull$;
import play.api.libs.json.JsNumber;
import play.api.libs.json.JsObject;
import play.api.libs.json.JsObject$;
import play.api.libs.json.JsString;
import play.api.libs.json.JsValue;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IndexedSeq;
import scala.collection.Map;
import scala.collection.Seq;
import scala.math.BigDecimal;
import scala.math.BigDecimal$;
import scala.package$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichDouble$;
import scalaz.;
import scalaz.$bslash$div$minus$;
import scalaz.$minus$bslash$div$;

public final class Play2Msgpack$ {
    public static final Play2Msgpack$ MODULE$ = new Play2Msgpack$();
    private static final JsBoolean JsTrue = JsBoolean$.MODULE$.apply(true);
    private static final JsBoolean JsFalse = JsBoolean$.MODULE$.apply(false);

    public MsgpackCodec<JsValue> jsValueCodec(PlayUnpackOptions options) {
        return new CodecPlay2JsValue(options);
    }

    public MsgpackCodec<JsArray> jsArrayCodec(PlayUnpackOptions options) {
        return new CodecPlay2JsArray(options);
    }

    public MsgpackCodec<JsObject> jsObjCodec(PlayUnpackOptions options) {
        return new CodecPlay2JsObject(options);
    }

    public Tuple3<MsgpackCodec<JsValue>, MsgpackCodec<JsArray>, MsgpackCodec<JsObject>> allCodec(PlayUnpackOptions options) {
        return new Tuple3(this.jsValueCodec(options), this.jsArrayCodec(options), this.jsObjCodec(options));
    }

    public void jsObj2msgpack(MsgPacker packer, JsObject obj) {
        Map fields = obj.value();
        packer.packMapHeader(fields.size());
        fields.foreach((Function1 & Serializable)field -> {
            Play2Msgpack$.$anonfun$jsObj2msgpack$1(packer, field);
            return BoxedUnit.UNIT;
        });
        packer.mapEnd();
    }

    public void jsArray2msgpack(MsgPacker packer, JsArray array) {
        packer.packArrayHeader(array.value().size());
        array.value().foreach((Function1 & Serializable)x -> {
            Play2Msgpack$.MODULE$.json2msgpack(packer, x);
            return BoxedUnit.UNIT;
        });
        packer.arrayEnd();
    }

    public void json2msgpack(MsgPacker packer, JsValue json) {
        JsBoolean jsBoolean;
        Option option;
        JsValue jsValue = json;
        if (jsValue instanceof JsNumber) {
            JsNumber jsNumber = (JsNumber)jsValue;
            BigDecimal v = jsNumber.value();
            if (v.isValidLong()) {
                packer.packLong(v.longValue());
                return;
            }
            float f = v.floatValue();
            if (BoxesRunTime.equals((Object)BoxesRunTime.boxToFloat((float)f), (Object)v)) {
                packer.packFloat(f);
                return;
            }
            packer.packDouble(v.doubleValue());
            return;
        }
        if (jsValue instanceof JsString) {
            JsString jsString = (JsString)jsValue;
            String v = jsString.value();
            packer.packString(v);
            return;
        }
        if (jsValue instanceof JsBoolean && !(option = JsBoolean$.MODULE$.unapply(jsBoolean = (JsBoolean)jsValue)).isEmpty()) {
            boolean v = BoxesRunTime.unboxToBoolean((Object)option.get());
            packer.packBoolean(v);
            return;
        }
        if (jsValue instanceof JsObject) {
            JsObject jsObject = (JsObject)jsValue;
            this.jsObj2msgpack(packer, jsObject);
            return;
        }
        if (jsValue instanceof JsArray) {
            JsArray jsArray = (JsArray)jsValue;
            this.jsArray2msgpack(packer, jsArray);
            return;
        }
        if (JsNull$.MODULE$.equals(jsValue)) {
            packer.packNil();
            return;
        }
        throw new MatchError((Object)jsValue);
    }

    public .bslash.div<UnpackError, JsValue> msgpack2json(MsgUnpacker unpacker, PlayUnpackOptions unpackOptions) {
        Play2Msgpack.Result<JsValue> result = Play2Msgpack$Result$.MODULE$.empty();
        if (this.msgpack2json0(unpacker, result, unpackOptions)) {
            return $bslash$div$minus$.MODULE$.apply((Object)result.value());
        }
        return $minus$bslash$div$.MODULE$.apply((Object)result.error());
    }

    public .bslash.div<UnpackError, JsObject> msgpack2jsObj(MsgUnpacker unpacker, PlayUnpackOptions unpackOptions) {
        Play2Msgpack.Result<JsObject> result = Play2Msgpack$Result$.MODULE$.empty();
        if (this.msgpack2jsObj0(unpacker, result, unpackOptions)) {
            return $bslash$div$minus$.MODULE$.apply((Object)result.value());
        }
        return $minus$bslash$div$.MODULE$.apply((Object)result.error());
    }

    public .bslash.div<UnpackError, JsArray> msgpack2jsArray(MsgUnpacker unpacker, PlayUnpackOptions unpackOptions) {
        Play2Msgpack.Result<JsArray> result = Play2Msgpack$Result$.MODULE$.empty();
        if (this.msgpack2jsArray0(unpacker, result, unpackOptions)) {
            return $bslash$div$minus$.MODULE$.apply((Object)result.value());
        }
        return $minus$bslash$div$.MODULE$.apply((Object)result.error());
    }

    private boolean msgpack2jsObj0(MsgUnpacker unpacker, Play2Msgpack.Result<JsObject> result, PlayUnpackOptions unpackOptions) {
        BooleanRef success;
        block4: {
            int size = unpacker.unpackMapHeader();
            Tuple2[] fields = new Tuple2[size];
            IntRef i = IntRef.create((int)0);
            Play2Msgpack.Result mapElem = Play2Msgpack$Result$.MODULE$.empty();
            success = BooleanRef.create((boolean)true);
            while (i.elem < size && success.elem) {
                MsgType tpe;
                MsgType msgType = tpe = unpacker.nextType();
                MsgType msgType2 = MsgType.STRING;
                if (!(msgType != null ? !msgType.equals(msgType2) : msgType2 != null)) {
                    this.process$1(unpacker.unpackString(), unpacker, mapElem, unpackOptions, fields, i, result, success);
                    continue;
                }
                Option option = (Option)unpackOptions.nonStringKey().apply((Object)tpe, (Object)unpacker);
                if (option instanceof Some) {
                    Some some = (Some)option;
                    String key = (String)some.value();
                    this.process$1(key, unpacker, mapElem, unpackOptions, fields, i, result, success);
                    continue;
                }
                if (None$.MODULE$.equals(option)) {
                    success.elem = false;
                    result.error_$eq((UnpackError)new Other("not string key"));
                    continue;
                }
                throw new MatchError((Object)option);
            }
            unpacker.mapEnd();
            if (!success.elem) break block4;
            result.value_$eq(JsObject$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])fields).toVector()));
        }
        return success.elem;
    }

    private boolean msgpack2jsArray0(MsgUnpacker unpacker, Play2Msgpack.Result<JsArray> result, PlayUnpackOptions unpackOptions) {
        boolean success;
        block2: {
            int size = unpacker.unpackArrayHeader();
            JsValue[] array = new JsValue[size];
            int i = 0;
            Play2Msgpack.Result<Object> arrayElem = new Play2Msgpack.Result<Object>(null, null);
            success = true;
            while (i < size && success) {
                if (this.msgpack2json0(unpacker, arrayElem, unpackOptions)) {
                    array[i] = arrayElem.value();
                    ++i;
                    continue;
                }
                result.error_$eq(arrayElem.error());
                success = false;
            }
            unpacker.arrayEnd();
            if (!success) break block2;
            result.value_$eq(new JsArray((IndexedSeq)Predef$.MODULE$.wrapRefArray((Object[])array).toVector()));
        }
        return success;
    }

    private boolean msgpack2json0(MsgUnpacker unpacker, Play2Msgpack.Result<JsValue> result, PlayUnpackOptions unpackOptions) {
        MsgType msgType = unpacker.nextType();
        if (MsgType.NIL.equals(msgType)) {
            unpacker.unpackNil();
            result.value_$eq((JsValue)JsNull$.MODULE$);
            return true;
        }
        if (MsgType.BOOLEAN.equals(msgType)) {
            if (unpacker.unpackBoolean()) {
                result.value_$eq((JsValue)JsTrue);
            } else {
                result.value_$eq((JsValue)JsFalse);
            }
            return true;
        }
        if (MsgType.INTEGER.equals(msgType)) {
            result.value_$eq((JsValue)new JsNumber(BigDecimal$.MODULE$.javaBigDecimal2bigDecimal(new java.math.BigDecimal(unpacker.unpackBigInteger()))));
            return true;
        }
        if (MsgType.FLOAT.equals(msgType)) {
            boolean bl;
            double f = unpacker.unpackDouble();
            try {
                result.value_$eq((JsValue)new JsNumber(package$.MODULE$.BigDecimal().valueOf(f)));
                bl = true;
            }
            catch (Throwable throwable) {
                boolean bl2 = false;
                NumberFormatException numberFormatException = null;
                Throwable throwable2 = throwable;
                if (throwable2 instanceof NumberFormatException) {
                    bl2 = true;
                    numberFormatException = (NumberFormatException)throwable2;
                    if (RichDouble$.MODULE$.isPosInfinity$extension(Predef$.MODULE$.doubleWrapper(f))) {
                        bl = Play2Msgpack$Result$.MODULE$.fromEither(unpackOptions.positiveInf(), result);
                    }
                }
                if (bl2 && RichDouble$.MODULE$.isNegInfinity$extension(Predef$.MODULE$.doubleWrapper(f))) {
                    bl = Play2Msgpack$Result$.MODULE$.fromEither(unpackOptions.negativeInf(), result);
                }
                if (bl2 && Double.isNaN(f)) {
                    bl = Play2Msgpack$Result$.MODULE$.fromEither(unpackOptions.nan(), result);
                }
                throw throwable;
            }
            return bl;
        }
        if (MsgType.STRING.equals(msgType)) {
            result.value_$eq((JsValue)new JsString(unpacker.unpackString()));
            return true;
        }
        if (MsgType.ARRAY.equals(msgType)) {
            Play2Msgpack.Result<JsArray> result0 = Play2Msgpack$Result$.MODULE$.empty();
            boolean r = this.msgpack2jsArray0(unpacker, result0, unpackOptions);
            result.error_$eq(result0.error());
            result.value_$eq((JsValue)result0.value());
            return r;
        }
        if (MsgType.MAP.equals(msgType)) {
            Play2Msgpack.Result<JsObject> result0 = Play2Msgpack$Result$.MODULE$.empty();
            boolean r = this.msgpack2jsObj0(unpacker, result0, unpackOptions);
            result.error_$eq(result0.error());
            result.value_$eq((JsValue)result0.value());
            return r;
        }
        if (MsgType.BINARY.equals(msgType)) {
            return Play2Msgpack$Result$.MODULE$.fromEither((.bslash.div)unpackOptions.binary().apply((Object)unpacker), result);
        }
        if (MsgType.EXTENSION.equals(msgType)) {
            return Play2Msgpack$Result$.MODULE$.fromEither((.bslash.div)unpackOptions.extension().apply((Object)unpacker), result);
        }
        throw new MatchError((Object)msgType);
    }

    public static final /* synthetic */ void $anonfun$jsObj2msgpack$1(MsgPacker packer$1, Tuple2 field) {
        packer$1.packString((String)field._1());
        MODULE$.json2msgpack(packer$1, (JsValue)field._2());
    }

    private final void process$1(String key, MsgUnpacker unpacker$1, Play2Msgpack.Result mapElem$1, PlayUnpackOptions unpackOptions$1, Tuple2[] fields$1, IntRef i$1, Play2Msgpack.Result result$1, BooleanRef success$1) {
        if (this.msgpack2json0(unpacker$1, mapElem$1, unpackOptions$1)) {
            fields$1[i$1.elem] = new Tuple2((Object)key, mapElem$1.value());
            ++i$1.elem;
            return;
        }
        result$1.error_$eq(mapElem$1.error());
        success$1.elem = false;
    }

    private Play2Msgpack$() {
    }
}

